/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import java.io.FileNotFoundException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.core.IBeanInfoContributor;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.java.JavaClass;
import org.osgi.framework.Bundle;

public class BeanInfoContributorAdapter
implements IBeanInfoContributor {
    public static final BeaninfoEntry[] EMPTY_BEANINFO_ENTRIES = new BeaninfoEntry[0];

    protected boolean isFragment(IPath fragment, IPath packagePath) {
        return fragment.isPrefixOf(packagePath);
    }

    protected String getUnmatchedPath(IPath fragment, IPath packagePath) {
        return fragment.removeFirstSegments(packagePath.segmentCount()).toString();
    }

    protected Resource loadOverrideResource(Bundle bundle, String relativePath, ResourceSet rset, BeaninfoPlugin.IContributorOverrideRunnable runnable) {
        Resource result;
        block6: {
            URI uri = URI.createURI((String)("platform:/plugin/" + bundle.getSymbolicName() + '/' + relativePath));
            if (runnable.resourceContributed(uri)) {
                return null;
            }
            result = null;
            try {
                result = rset.getResource(uri, true);
            }
            catch (WrappedException e) {
                if (!(e.exception() instanceof FileNotFoundException || e.exception() instanceof CoreException && ((CoreException)((Object)e.exception())).getStatus().getCode() == 368)) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error loading file\"" + uri + "\"", (Throwable)e.exception()));
                }
                result = null;
                Resource res = rset.getResource(uri, false);
                if (res != null) {
                    rset.getResources().remove((Object)res);
                }
            }
            catch (Exception e) {
                BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error loading file\"" + uri + "\"", (Throwable)e));
                result = null;
                Resource res = rset.getResource(uri, false);
                if (res == null) break block6;
                rset.getResources().remove((Object)res);
            }
        }
        return result;
    }

    @Override
    public BeaninfoEntry[] getBeanInfoEntryContributions(IConfigurationContributionInfo info) {
        return EMPTY_BEANINFO_ENTRIES;
    }

    @Override
    public void runOverrides(IPath packagePath, String className, JavaClass javaClass, ResourceSet rset, BeaninfoPlugin.IContributorOverrideRunnable runnable) {
    }
}

