/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Hashtable;
import junit.framework.Assert;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class Requestor
extends Assert
implements ICompilerRequestor {
    public boolean hasErrors = false;
    public IProblemFactory problemFactory;
    public String outputPath;
    private boolean generateOutput;
    public Hashtable expectedProblems = new Hashtable();
    public String problemLog = "";
    public ICompilerRequestor clientRequestor;
    public boolean showCategory = false;
    public boolean showWarningToken = false;

    public Requestor(IProblemFactory problemFactory, String outputPath, boolean generateOutput, ICompilerRequestor clientRequestor, boolean showCategory, boolean showWarningToken) {
        this.problemFactory = problemFactory;
        this.outputPath = outputPath;
        this.generateOutput = generateOutput;
        this.clientRequestor = clientRequestor;
        this.showCategory = showCategory;
        this.showWarningToken = showWarningToken;
    }

    public void acceptResult(CompilationResult compilationResult) {
        StringBuffer buffer = new StringBuffer(100);
        this.hasErrors |= compilationResult.hasErrors();
        if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
            CategorizedProblem[] problems = compilationResult.getAllProblems();
            int count = problems.length;
            int problemCount = 0;
            char[] unitSource = compilationResult.compilationUnit.getContents();
            int i = 0;
            while (i < count) {
                DefaultProblem problem = (DefaultProblem)problems[i];
                if (problem != null) {
                    if (problemCount == 0) {
                        buffer.append("----------\n");
                    }
                    buffer.append(String.valueOf(++problemCount) + (problem.isError() ? ". ERROR" : ". WARNING"));
                    buffer.append(" in " + new String(problem.getOriginatingFileName()).replace('/', '\\'));
                    try {
                        String warningToken;
                        long irritant;
                        String category;
                        buffer.append(problem.errorReportSource(unitSource));
                        buffer.append("\n");
                        if (this.showCategory && (category = problem.getInternalCategoryMessage()) != null) {
                            buffer.append("[@cat:").append(category).append("] ");
                        }
                        if (this.showWarningToken && (irritant = ProblemReporter.getIrritant((int)problem.getID())) != 0L && (warningToken = CompilerOptions.warningTokenFromIrritant((long)irritant)) != null) {
                            buffer.append("[@sup:").append(warningToken).append("] ");
                        }
                        buffer.append(problem.getMessage());
                        buffer.append("\n");
                    }
                    catch (Exception exception) {}
                    buffer.append("----------\n");
                }
                ++i;
            }
            this.problemLog = String.valueOf(this.problemLog) + buffer.toString();
        }
        if (this.clientRequestor != null) {
            this.clientRequestor.acceptResult(compilationResult);
        }
    }
}

