/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.IEntryChangeListener;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;

public class SnippetPaletteRoot
extends PaletteRoot
implements IEntryChangeListener {
    protected SnippetDefinitions fDefinitions = null;

    public SnippetPaletteRoot(SnippetDefinitions definitions) {
        this.setDefinitions(definitions);
    }

    public void connect() {
        SnippetManager.getInstance().addEntryChangeListener(this);
        this.addPropertyChangeListener(SnippetManager.getInstance());
    }

    public void disconnect() {
        this.removePropertyChangeListener(SnippetManager.getInstance());
        SnippetManager.getInstance().removeEntryChangeListener(this);
    }

    public SnippetDefinitions getDefinitions() {
        return this.fDefinitions;
    }

    @Override
    public void modelChanged(SnippetDefinitions oldDefinitions, SnippetDefinitions newDefinitions) {
        this.setDefinitions(newDefinitions);
    }

    public void setDefinitions(SnippetDefinitions newDefinitions) {
        SnippetDefinitions oldDefinitions = this.getDefinitions();
        this.fDefinitions = newDefinitions;
        List<ISnippetCategory> oldChildren = null;
        if (oldDefinitions != null) {
            oldChildren = oldDefinitions.getCategories();
        }
        List<ISnippetCategory> categories = this.fDefinitions.getCategories();
        this.children = new ArrayList(categories.size());
        int i = 0;
        while (i < categories.size()) {
            PaletteEntry e = (PaletteEntry)categories.get(i);
            this.children.add(e);
            e.setParent((PaletteContainer)this);
            ++i;
        }
        if (Logger.DEBUG_VIEWER_CONTENT) {
            System.out.println(this.getClass().getName() + "@" + this.hashCode() + " setting categories to: " + String.valueOf(this.children));
        }
        this.listeners.firePropertyChange("Children Changed", oldChildren, this.children);
    }
}

