/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTRGroupLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowInfo;

public class CSSTRLayout
extends CSSBlockFlowLayout {
    public CSSTRLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    public CSSTableLayout2 getTableLayoutContext() {
        IFigure parent = this.getCSSFigure().getParent();
        if (parent != null) {
            LayoutManager parentLayout = parent.getLayoutManager();
            if (parentLayout instanceof CSSTableLayout2) {
                return (CSSTableLayout2)parentLayout;
            }
            if (parentLayout instanceof CSSTRGroupLayout) {
                return ((CSSTRGroupLayout)parentLayout).getTableLayoutContext();
            }
        }
        return null;
    }

    public CSSTRGroupLayout getTRGroupLayout() {
        LayoutManager parentLayout;
        IFigure parent = this.getCSSFigure().getParent();
        if (parent != null && (parentLayout = parent.getLayoutManager()) instanceof CSSTRGroupLayout) {
            return (CSSTRGroupLayout)parentLayout;
        }
        return null;
    }

    @Override
    public void postValidate() {
        CSSTableLayout2 tableLayout = this.getTableLayoutContext();
        if (tableLayout == null) {
            super.postValidate();
        } else {
            Rectangle r = this.getTRRect(tableLayout, this.getTRGroupLayout());
            if (r != null) {
                this._blockBox.setXYWidthHeight(r);
                this.getCSSFigure().setBounds(r);
                List list = this.getCSSFigure().getChildren();
                int i = 0;
                while (i < list.size()) {
                    ((FlowFigure)((Object)list.get(i))).postValidate();
                    ++i;
                }
            } else {
                super.postValidate();
            }
        }
    }

    @Override
    protected void endBlock() {
        if (this.getTableLayoutContext() == null) {
            super.endBlock();
        } else {
            this.layoutLines();
        }
    }

    @Override
    public boolean useLocalCoordinates() {
        return this.getTableLayoutContext() == null;
    }

    private Rectangle getTRRect(CSSTableLayout2 tableLayout, CSSTRGroupLayout groupLayout) {
        TableRowInfo rowinfo = tableLayout.getRowInfo(this.getCSSFigure());
        int rowIndex = rowinfo.getRowIndex();
        int y = (rowIndex + 1) * tableLayout.getVSpacing();
        int k = 0;
        while (k < rowIndex) {
            y += tableLayout.getRowHeights()[k];
            ++k;
        }
        if (tableLayout.getCaptionInfo() != null && "top".equalsIgnoreCase(tableLayout.getCaptionInfo().getAlign())) {
            y += tableLayout.getCaptionSize().height;
        }
        int height = tableLayout.getRowHeights()[rowIndex];
        return new Rectangle(tableLayout.getRowX(), y, tableLayout.getRowWidth(), height);
    }

    @Override
    public boolean handlingBorderForBlock() {
        return false;
    }
}

