/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class WarningMessageDialogWithToggle
extends MessageDialogWithToggle {
    private Text _messageLabel;

    public static MessageDialogWithToggle openOkCancelConfirm(Shell parent, String title, String message, String toggleMessage, boolean toggleState, IPreferenceStore store, String key) {
        WarningMessageDialogWithToggle dialog = new WarningMessageDialogWithToggle(parent, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1, toggleMessage, toggleState);
        dialog.open();
        return dialog;
    }

    WarningMessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this._messageLabel = new Text(composite, this.getMessageLabelStyle() | 8);
            this._messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this._messageLabel);
        }
        return composite;
    }

    private void addAccessibleListeners(Label label, final Image image) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String accessibleMessage = WarningMessageDialogWithToggle.this.getAccessibleMessageFor(image);
                if (accessibleMessage == null) {
                    return;
                }
                event.result = accessibleMessage;
            }
        });
    }

    private String getAccessibleMessageFor(Image image) {
        if (image.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString((String)"error");
        }
        if (image.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString((String)"warning");
        }
        if (image.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString((String)"info");
        }
        if (image.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString((String)"question");
        }
        return null;
    }
}

