/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.util.DefaultTableUtil;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.ManyToManyJoinPropsPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.ManyToManyMappingPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.ManyToOneJoinPropsPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.ManyToOneMappingPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.OneToManyJoinPropsPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.OneToManyMappingPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.OneToOneJoinPropsPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.OneToOneMappingPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class AssociationAnnotationWizard
extends Wizard {
    protected static final int JOIN_PROP_GROUP_HEIGHT = 300;
    private PersistenceUnit persistenceUnit;
    private ResourceManager resourceManager;
    private EntityRefPropertyElem refElem;
    private IProject project;
    private Schema schema;
    private String javaClass;
    private Table table;
    private CardinalityPage cardinalityPage;
    private ManyToManyMappingPage mtmPage;
    private OneToManyMappingPage otmPage;
    private ManyToOneMappingPage mtoPage;
    private OneToOneMappingPage otoPage;
    private ManyToManyJoinPropsPage mtmJoinPropsPage;
    private OneToManyJoinPropsPage otmJoinPropsPage;
    private ManyToOneJoinPropsPage mtoJoinPropsPage;
    private OneToOneJoinPropsPage otoJoinPropsPage;
    private Button oneToManyRadio;
    private Button manyToManyRadio;
    private Button oneToOneRadio;
    private Button manyToOneRadio;

    public AssociationAnnotationWizard(PersistenceUnit persistenceUnit, ResourceManager resourceManager, IProject project, String javaClass, Schema schema, Table table, EntityRefPropertyElem refElem) {
        this.persistenceUnit = persistenceUnit;
        this.resourceManager = resourceManager;
        this.project = project;
        this.javaClass = javaClass;
        this.schema = schema;
        this.table = table;
        this.refElem = refElem;
        this.setWindowTitle(JptJpaUiMakePersistentMessages.ASSOCIATION_WIZARD_TITLE);
    }

    public void addPages() {
        try {
            super.addPages();
            this.cardinalityPage = new CardinalityPage(this.refElem);
            String refClass = this.refElem.getRefEntityClassName();
            Table refTable = null;
            refTable = refClass.equals(this.javaClass) ? this.table : DefaultTableUtil.findTable((Schema)this.schema, (String)refClass, (PersistenceUnit)this.persistenceUnit);
            if (refTable != null) {
                this.refElem.setReferencedTable(refTable);
            }
            this.mtmJoinPropsPage = new ManyToManyJoinPropsPage(this.persistenceUnit, this.resourceManager, this.project, this.javaClass, this.schema, this.table, refTable, this.refElem);
            this.otmJoinPropsPage = new OneToManyJoinPropsPage(this.persistenceUnit, this.resourceManager, this.project, this.javaClass, this.schema, this.table, refTable, this.refElem);
            this.mtoJoinPropsPage = new ManyToOneJoinPropsPage(this.persistenceUnit, this.resourceManager, this.project, this.javaClass, this.schema, this.table, refTable, this.refElem);
            this.otoJoinPropsPage = new OneToOneJoinPropsPage(this.persistenceUnit, this.resourceManager, this.project, this.javaClass, this.schema, this.table, refTable, this.refElem);
            this.mtmPage = new ManyToManyMappingPage(this.persistenceUnit, this.resourceManager, this.project, this.refElem, (IWizardPage)this.mtmJoinPropsPage);
            this.otmPage = new OneToManyMappingPage(this.persistenceUnit, this.resourceManager, this.project, this.refElem, (IWizardPage)this.otmJoinPropsPage);
            this.mtoPage = new ManyToOneMappingPage(this.persistenceUnit, this.resourceManager, this.project, this.refElem, (IWizardPage)this.mtoJoinPropsPage);
            this.otoPage = new OneToOneMappingPage(this.persistenceUnit, this.resourceManager, this.project, this.refElem, (IWizardPage)this.otoJoinPropsPage);
            this.addPage((IWizardPage)this.cardinalityPage);
            this.addPage((IWizardPage)this.mtmPage);
            this.addPage((IWizardPage)this.otmPage);
            this.addPage((IWizardPage)this.mtoPage);
            this.addPage((IWizardPage)this.otoPage);
            this.addPage((IWizardPage)this.mtmJoinPropsPage);
            this.addPage((IWizardPage)this.otmJoinPropsPage);
            this.addPage((IWizardPage)this.mtoJoinPropsPage);
            this.addPage((IWizardPage)this.otoJoinPropsPage);
        }
        catch (Exception e) {
            JptJpaUiPlugin.instance().logError(e);
        }
    }

    public boolean performFinish() {
        return true;
    }

    static void displayNoTargetEntityError(String propertyName) {
        MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 1);
        msgBox.setText(JptJpaUiMakePersistentMessages.ASSOCIATION_WIZARD_ERROR);
        String msg = String.format(JptJpaUiMakePersistentMessages.ASSOCIATION_WIZARD_NO_TARGET_ENTITY, propertyName);
        msgBox.setMessage(msg);
        msgBox.open();
    }

    static Label createLabel(Composite container, int span, String text) {
        return AssociationAnnotationWizard.createLabel(container, span, text, -1);
    }

    static Label createLabel(Composite container, int span, String text, int widthHint) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        label.setLayoutData((Object)gd);
        return label;
    }

    static Button createButton(Composite container, int span, String text, int widthHint, int style) {
        Button button = new Button(container, style);
        if (text != null) {
            button.setText(text);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        button.setLayoutData((Object)gd);
        return button;
    }

    static Text createText(Composite container, int span, boolean fillHorizontal, String text, int style) {
        return AssociationAnnotationWizard.createText(container, span, fillHorizontal, text, style, -1);
    }

    static Text createText(Composite container, int span, boolean fillHorizontal, String text, int style, int widthHint) {
        Text textCtl = new Text(container, style);
        if (text != null) {
            textCtl.setText(text);
        }
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.widthHint = widthHint;
        gd.horizontalSpan = span;
        textCtl.setLayoutData((Object)gd);
        return textCtl;
    }

    static Button createImageButton(Composite container, Image image, int span, int style, String toolTipText) {
        Button button = new Button(container, style);
        button.setImage(image);
        GridData gd = new GridData(3, 2, false, false);
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        if (toolTipText != null) {
            button.setToolTipText(toolTipText);
        }
        return button;
    }

    static Combo createCombo(Composite container, boolean fillHorizontal, int colSpan, int style) {
        return AssociationAnnotationWizard.createCombo(container, fillHorizontal, colSpan, style, -1);
    }

    static Combo createCombo(Composite container, boolean fillHorizontal, int colSpan, int style, int widthHint) {
        Combo combo = new Combo(container, style);
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.widthHint = widthHint;
        gd.horizontalSpan = colSpan;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    static Text createText(Composite container, boolean fillHorizontal, int colSpan, int style) {
        Text text = new Text(container, style);
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.horizontalSpan = colSpan;
        text.setLayoutData((Object)gd);
        return text;
    }

    private class CardinalityPage
    extends WizardPage {
        private EntityRefPropertyElem refElem;

        public CardinalityPage(EntityRefPropertyElem refElem) {
            super("Cardinality Page");
            this.refElem = refElem;
            this.setTitle(JptJpaUiMakePersistentMessages.CARDINALITY_PAGE_TITLE);
            this.setMessage(JptJpaUiMakePersistentMessages.CARDINALITY_PAGE_DESC);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            composite.setLayout((Layout)gl);
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CardinalityPage.this.handleCardinalityChange();
                }
            };
            if (this.refElem.isOneToMany() || this.refElem.isManyToMany()) {
                AssociationAnnotationWizard.this.oneToManyRadio = new Button(composite, 16);
                AssociationAnnotationWizard.this.oneToManyRadio.setText("one-to-many");
                AssociationAnnotationWizard.this.oneToManyRadio.addSelectionListener((SelectionListener)selectionAdapter);
                AssociationAnnotationWizard.this.manyToManyRadio = new Button(composite, 16);
                AssociationAnnotationWizard.this.manyToManyRadio.setText("many-to-many");
                AssociationAnnotationWizard.this.manyToManyRadio.addSelectionListener((SelectionListener)selectionAdapter);
                if (this.refElem.isOneToMany()) {
                    AssociationAnnotationWizard.this.oneToManyRadio.setSelection(true);
                } else {
                    AssociationAnnotationWizard.this.manyToManyRadio.setSelection(true);
                }
            } else {
                AssociationAnnotationWizard.this.oneToOneRadio = new Button(composite, 16);
                AssociationAnnotationWizard.this.oneToOneRadio.setText("one-to-one");
                AssociationAnnotationWizard.this.oneToOneRadio.addSelectionListener((SelectionListener)selectionAdapter);
                AssociationAnnotationWizard.this.manyToOneRadio = new Button(composite, 16);
                AssociationAnnotationWizard.this.manyToOneRadio.setText("many-to-one");
                AssociationAnnotationWizard.this.manyToOneRadio.addSelectionListener((SelectionListener)selectionAdapter);
                if (this.refElem.isOneToOne()) {
                    AssociationAnnotationWizard.this.oneToOneRadio.setSelection(true);
                } else {
                    AssociationAnnotationWizard.this.manyToOneRadio.setSelection(true);
                }
            }
            this.setControl((Control)composite);
        }

        public IWizardPage getNextPage() {
            if (this.refElem.isOneToMany()) {
                return AssociationAnnotationWizard.this.otmPage;
            }
            if (this.refElem.isManyToMany()) {
                return AssociationAnnotationWizard.this.mtmPage;
            }
            if (this.refElem.isManyToOne()) {
                return AssociationAnnotationWizard.this.mtoPage;
            }
            if (this.refElem.isOneToOne()) {
                return AssociationAnnotationWizard.this.otoPage;
            }
            return null;
        }

        private void handleCardinalityChange() {
            if (AssociationAnnotationWizard.this.oneToManyRadio != null && AssociationAnnotationWizard.this.oneToManyRadio.getSelection()) {
                this.refElem.setTagName("one-to-many");
            } else if (AssociationAnnotationWizard.this.manyToManyRadio != null && AssociationAnnotationWizard.this.manyToManyRadio.getSelection()) {
                this.refElem.setTagName("many-to-many");
            } else if (AssociationAnnotationWizard.this.manyToOneRadio != null && AssociationAnnotationWizard.this.manyToOneRadio.getSelection()) {
                this.refElem.setTagName("many-to-one");
            } else if (AssociationAnnotationWizard.this.oneToOneRadio != null && AssociationAnnotationWizard.this.oneToOneRadio.getSelection()) {
                this.refElem.setTagName("one-to-one");
            }
            this.refElem.removeMappedBy();
        }
    }
}

