/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class TestUnsupportedContentType
extends TestCase {
    static IProject createSimpleProject(String name) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            if (!project.exists()) {
                project.create(description, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!project.isAccessible()) {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    public void testGetForReadWithUnsupported() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
        if (!project.isAccessible()) {
            project = TestUnsupportedContentType.createSimpleProject(this.getName());
        }
        IFile file = project.getFile("testReadFile.js");
        file.create((InputStream)new ByteArrayInputStream("var n = 0;".getBytes()), true, null);
        TestUnsupportedContentType.assertTrue((String)"test file not created", (boolean)file.isAccessible());
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(file);
            TestUnsupportedContentType.assertNull((String)"model returned even though expected to silently get null", (Object)model);
            if (model != null) {
                model.releaseFromRead();
            }
        }
        catch (Exception e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            TestUnsupportedContentType.fail((String)out.toString());
        }
        project.delete(true, null);
    }

    public void testGetForEditWithUnsupported() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
        if (!project.isAccessible()) {
            project = TestUnsupportedContentType.createSimpleProject(this.getName());
        }
        IFile file = project.getFile("testEditFile.js");
        file.create((InputStream)new ByteArrayInputStream("var n = 0;".getBytes()), true, null);
        TestUnsupportedContentType.assertTrue((String)"test file not created", (boolean)file.isAccessible());
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
            TestUnsupportedContentType.assertNull((String)"model returned even though expected to silently get null", (Object)model);
            if (model != null) {
                model.releaseFromRead();
            }
        }
        catch (Exception e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            TestUnsupportedContentType.fail((String)out.toString());
        }
        project.delete(true, null);
    }
}

