/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.wsdl.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class WSDLSelectionMapper implements ISelectionMapper {

	public ISelection mapSelection(ISelection selection) {
		List list = new ArrayList();
		if (selection instanceof StructuredSelection) {  
			StructuredSelection structuredSelection = (StructuredSelection)selection;
			for (Iterator i = structuredSelection.iterator(); i.hasNext(); ) {
				Object o = i.next();
				if (o instanceof Adapter) {
					list.add(((Adapter)o).getTarget());
				}  
				else {
					list.add(o);
				}  
			}  
		}
		return new StructuredSelection(list);
	}
}