/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class NameSection
extends AbstractSection {
    private final String NAME = DTDPropertiesMessages._UI_LABEL_NAME;
    private Text nameText;

    @Override
    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText) {
            Object input = this.getInput();
            String newValue = this.nameText.getText();
            if (newValue.length() > 0 && input instanceof DTDNode) {
                DTDNode dtdNode = (DTDNode)input;
                dtdNode.setName(newValue);
            }
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, this.NAME);
        Point p = nameLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, -5);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)nameLabel, 0, 0x1000000);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addListener(24, (Listener)this);
    }

    @Override
    public void refresh() {
        this.setListenerEnabled(false);
        this.nameText.setEnabled(true);
        Object input = this.getInput();
        this.nameText.setText("");
        if (input != null && input instanceof DTDNode) {
            this.nameText.setText(((DTDNode)input).getName());
        }
        this.setListenerEnabled(true);
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }
}

