/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.ejb.AssemblyDescriptor;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class AssemblyDescriptorMerger
extends ModelElementMerger {
    public AssemblyDescriptorMerger(JavaEEObject _base, JavaEEObject merge, int _kind) {
        super(_base, merge, _kind);
    }

    AssemblyDescriptor getBaseAssemblyDescriptor() {
        return (AssemblyDescriptor)this.getBase();
    }

    AssemblyDescriptor getToMergeAssemblyDescriptor() {
        return (AssemblyDescriptor)this.getToMerge();
    }

    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        this.mergeSecurityRoles(warnings);
        this.mergeTransactionAttribute(warnings);
        this.copyGeneralData(warnings);
        return warnings;
    }

    private void mergeTransactionAttribute(List warnings) {
    }

    private void mergeSecurityRoles(List warnings) {
        List securityRolesBase = this.getBaseAssemblyDescriptor().getSecurityRoles();
        List securityRolesToMerge = this.getToMergeAssemblyDescriptor().getSecurityRoles();
        if (securityRolesToMerge == null) {
            return;
        }
        for (Object sRoles : securityRolesToMerge) {
            if (this.containsSecRole((SecurityRole)sRoles, securityRolesBase)) continue;
            securityRolesBase.add(EcoreUtil.copy((EObject)((EObject)sRoles)));
        }
    }

    private boolean containsSecRole(SecurityRole secRole, List secRoles) {
        for (Object sRoles : secRoles) {
            if (((SecurityRole)sRoles).getRoleName() == null || secRole.getRoleName() == null) {
                return ((SecurityRole)sRoles).getRoleName() == secRole.getRoleName();
            }
            if (!((SecurityRole)sRoles).getRoleName().equals(secRole.getRoleName())) continue;
            return true;
        }
        return false;
    }

    private void copyGeneralData(List warnings) {
        if (this.getToMergeAssemblyDescriptor().getApplicationExceptions() != null && this.getToMergeAssemblyDescriptor().getApplicationExceptions().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeAssemblyDescriptor().getApplicationExceptions(), this.getBaseAssemblyDescriptor().getApplicationExceptions());
        }
        if (this.getToMergeAssemblyDescriptor().getInterceptorBindings() != null && this.getToMergeAssemblyDescriptor().getInterceptorBindings().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeAssemblyDescriptor().getInterceptorBindings(), this.getBaseAssemblyDescriptor().getInterceptorBindings());
        }
        if (this.getToMergeAssemblyDescriptor().getContainerTransactions() != null && this.getToMergeAssemblyDescriptor().getContainerTransactions().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeAssemblyDescriptor().getContainerTransactions(), this.getBaseAssemblyDescriptor().getContainerTransactions());
        }
        if (this.getToMergeAssemblyDescriptor().getMessageDestinations() != null && this.getToMergeAssemblyDescriptor().getMessageDestinations().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeAssemblyDescriptor().getMessageDestinations(), this.getBaseAssemblyDescriptor().getMessageDestinations());
        }
        if (this.getToMergeAssemblyDescriptor().getMethodPermissions() != null && this.getToMergeAssemblyDescriptor().getMethodPermissions().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeAssemblyDescriptor().getMethodPermissions(), this.getBaseAssemblyDescriptor().getMethodPermissions());
        }
        if (this.getToMergeAssemblyDescriptor().getExcludeList() != null && this.getToMergeAssemblyDescriptor().getExcludeList().getMethods().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeAssemblyDescriptor().getExcludeList().getMethods(), this.getBaseAssemblyDescriptor().getExcludeList().getMethods());
        }
    }

    private void copyMissingContentInBase(List listSource, List target) {
        for (Object object : listSource) {
            target.add(EcoreUtil.copy((EObject)((EObject)object)));
        }
    }
}

