/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public class BeanProxyValueSender
implements Commands.ValueSender {
    protected int index = 0;
    protected Object[] array;
    private Exception exception;
    private final REMStandardBeanProxyFactory factory;

    public Exception getException() {
        return this.exception;
    }

    public BeanProxyValueSender(REMStandardBeanProxyFactory factory) {
        this.factory = factory;
    }

    public BeanProxyValueSender(REMStandardBeanProxyFactory factory, Commands.ValueObject arrayHeader) {
        this(factory);
        this.initialize(arrayHeader);
    }

    @Override
    public void initialize(Commands.ValueObject arrayHeader) {
        this.index = 0;
        this.array = new Object[arrayHeader.anInt];
    }

    public void clear() {
        this.array = null;
        this.index = 0;
    }

    public Object[] getArray() {
        return this.array;
    }

    @Override
    public void sendValue(Commands.ValueObject value) {
        try {
            this.array[this.index++] = this.factory.getBeanProxy(value);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.exception = e;
        }
        catch (CommandException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.exception = e;
        }
    }

    @Override
    public Commands.ValueSender nestedArray(Commands.ValueObject arrayHeader) {
        BeanProxyValueSender sender = new BeanProxyValueSender(this.factory, arrayHeader);
        this.array[this.index++] = sender.getArray();
        return sender;
    }
}

