/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.browserfixture;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.FixtureParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeCasting;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType;
import org.eclipse.wst.jsdt.chromium.internal.transport.ChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.transport.Connection;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebuggerCommand;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptImplTestGate;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8ContextFilter;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8Protocol;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8ProtocolParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ContextHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ScriptHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeHandle;
import org.eclipse.wst.jsdt.chromium.tests.internal.JsonBuilderUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class FixtureChromeStub
implements ChromeStub {
    private static final Map<Long, Integer> scriptIdToScriptRefMap = new HashMap<Long, Integer>();
    private static final V8ContextFilter contextFilter = new V8ContextFilter(){

        public boolean isContextOurs(ContextHandle contextHandle) {
            return true;
        }
    };
    private static final Map<Long, String> refToObjectMap = new HashMap<Long, String>();
    private static final Map<Long, String> refToFullVersionMap = new HashMap<Long, String>();
    private final ScriptManager scriptManager = ScriptImplTestGate.create(contextFilter);
    private final Map<Long, BreakpointImpl> breakpoints = new HashMap<Long, BreakpointImpl>();
    private boolean isRunning = true;
    private Connection.NetListener listener;
    private static long breakpointCounter;
    private static long seqCounter;
    private static final BreakpointManager NULL_BREAKPOINT_MANAGER;

    static {
        refToObjectMap.put(Long.valueOf(FixtureChromeStub.getMouseEventRef()), "{\"handle\":" + FixtureChromeStub.getMouseEventRef() + "," + "\"type\":\"object\",\"className\":\"MouseEvent\"," + "\"constructorFunction\":{\"ref\":19},\"protoObject\":{\"ref\":73}," + "\"prototypeObject\":{\"ref\":2},\"properties\":[" + "{\"name\":\"x\",\"propertyType\":3,\"ref\":" + FixtureChromeStub.getNumber3Ref() + "}," + "{\"name\":\"y\",\"propertyType\":3,\"ref\":" + FixtureChromeStub.getNumber3Ref() + "}]," + "\"text\":\"#<an Object>\"}");
        refToObjectMap.put(19L, JsonBuilderUtil.convertToRealJson("{'handle':19,'type':'null','text':'null'}"));
        refToObjectMap.put(73L, JsonBuilderUtil.convertToRealJson("{'handle':73,'type':'null','text':'null'}"));
        refToObjectMap.put(Long.valueOf(FixtureChromeStub.getScriptRef()), JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("handle", FixtureChromeStub.getScriptRef()), JsonBuilderUtil.jsonProperty("type", "script"), JsonBuilderUtil.jsonProperty("name", "file:///C:/1.js"), JsonBuilderUtil.jsonProperty("id", FixtureChromeStub.getScriptId()), JsonBuilderUtil.jsonProperty("lineOffset", 0), JsonBuilderUtil.jsonProperty("columnOffset", 0), JsonBuilderUtil.jsonProperty("lineCount", 32), JsonBuilderUtil.jsonProperty("source", "SomeObject = function() {\r\n  this.fieldOne = \"One\";\r\n};\r\n\r\nSomeObject.prototype.methodTwo = function() {\r\n  alert(this.fieldOne);\r\n}\r\n\r\n\r\nfunction clicked() {\r\n  var obj = {\r\n    objField : { internalObj : { intField : 1}, simpleString : \"foo\" },\r\n    someNumber : 3\r\n  };\r\n  var a = 1;\r\n\r\n  var arr;\r\n  arr = [\"foo\", 3, new Date(), obj, arr];\r\n  for (var i = 5; i < 240; i += 2) {\r\n    arr[i] = \"bar\";\r\n  }\r\n  arr[100] = 0.99999887;\r\n//  var b = a + 1\r\n//  console.log('Foo');\r\n  anotherScript();\r\n}\r\n\r\nfunction anotherScript() {\r\n  var i = 0;\r\n  i += 2;\r\n  var someObj = new SomeObject();\r\n}\r\n"), JsonBuilderUtil.jsonProperty("sourceLength", 595), JsonBuilderUtil.jsonProperty("type", "script"), JsonBuilderUtil.jsonProperty("type", "script"), JsonBuilderUtil.jsonProperty("scriptType", 2), JsonBuilderUtil.jsonProperty("context", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("ref", 0))), JsonBuilderUtil.jsonProperty("text", "file:///C:/1.js (lines: 32)"), JsonBuilderUtil.jsonProperty("compilationType", 17)).toJSONString());
        refToObjectMap.put(Long.valueOf(FixtureChromeStub.getCompiledScriptRef()), JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("handle", FixtureChromeStub.getCompiledScriptRef()), JsonBuilderUtil.jsonProperty("type", "script"), JsonBuilderUtil.jsonProperty("name", "file:///C:/2.js"), JsonBuilderUtil.jsonProperty("id", FixtureChromeStub.getCompiledScriptId()), JsonBuilderUtil.jsonProperty("lineOffset", 0), JsonBuilderUtil.jsonProperty("columnOffset", 0), JsonBuilderUtil.jsonProperty("lineCount", 32), JsonBuilderUtil.jsonProperty("source", "SomeObject = function() {\r\n  this.fieldOne = \"One\";\r\n};\r\n\r\nSomeObject.prototype.methodTwo = function() {\r\n  alert(this.fieldOne);\r\n}\r\n\r\n\r\nfunction compiled() {\r\n  var obj = {\r\n    compiled : { internalObj : { intField : 1}, simpleString : \"foo\" },\r\n    someNumber : 3\r\n  };\r\n  var a = 1;\r\n\r\n  var arr;\r\n  arr = [\"foo\", 3, new Date(), obj, arr];\r\n  for (var i = 5; i < 240; i += 2) {\r\n    arr[i] = \"bar\";\r\n  }\r\n  arr[100] = 0.99999887;\r\n//  var b = a + 1\r\n//  console.log('Foo');\r\n  anotherScript();\r\n}\r\n\r\nfunction anotherScript() {\r\n  var i = 0;\r\n  i += 2;\r\n  var someObj = new SomeObject();\r\n}\r\n"), JsonBuilderUtil.jsonProperty("sourceLength", 595), JsonBuilderUtil.jsonProperty("scriptType", 2), JsonBuilderUtil.jsonProperty("context", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("ref", 0))), JsonBuilderUtil.jsonProperty("text", "file:///C:/2.js (lines: 32)"), JsonBuilderUtil.jsonProperty("compilationType", 17)).toJSONString());
        refToObjectMap.put(Long.valueOf(FixtureChromeStub.getFunctionRef()), "{\"handle\":" + FixtureChromeStub.getFunctionRef() + ",\"type\":\"function\",\"className\":\"Function\"," + "\"constructorFunction\":{\"ref\":31},\"protoObject\":{\"ref\":32}," + "\"prototypeObject\":{\"ref\":33},\"name\":\"clicked\",\"inferredName\":\"\"," + "\"resolved\":true,\"source\":\"function clicked() {\\r\\n  var obj = {\\r\\n" + "    objField : { internalObj : { intField : 1}, simpleString : \\\"foo\\\" },\\r\\n" + "    someNumber : 3\\r\\n  };\\r\\n  var a = 1;\\r\\n\\r\\n  var arr;\\r\\n" + "  arr = [\\\"foo\\\", 3, new Date(), obj, arr];\\r\\n" + "  for (var i = 5; i < 240; i += 2) {\\r\\n    arr[i] = \\\"bar\\\";\\r\\n  }\\r\\n" + "  arr[100] = 0.99999887;\\r\\n//  var b = a + 1\\r\\n//  console.log('Foo');\\r\\n" + "  anotherScript();\\r\\n}\",\"script\":{\"ref\":" + FixtureChromeStub.getScriptRef() + "},\"properties\":[{\"name\":\"name\"," + "\"attributes\":7,\"propertyType\":3,\"ref\":34},{\"name\":\"caller\",\"attributes\":7," + "\"propertyType\":3,\"ref\":11},{\"name\":\"length\",\"attributes\":7,\"propertyType\":3," + "\"ref\":35},{\"name\":\"arguments\",\"attributes\":7,\"propertyType\":3,\"ref\":327}," + "{\"name\":\"prototype\",\"attributes\":4,\"propertyType\":3,\"ref\":33}]," + "\"text\":\"function clicked() {\\r\\n  var obj = {\\r\\n    objField : { internalObj :" + " { intField : 1}, simpleString : \\\"foo\\\" },\\r\\n    someNumber : 3\\r\\n  };\\r\\n" + "  var a = 1;\\r\\n\\r\\n  var arr;\\r\\n  arr = [\\\"foo\\\", 3, new Date(), obj, arr];" + "\\r\\n  for (var i = 5; i < 240; i += 2) {\\r\\n    arr[i] = \\\"bar\\\";\\r\\n  }\\r\\n" + "  arr[100] = 0.99999887;\\r\\n//  var b = a + 1\\r\\n//  console.log('Foo');\\r\\n" + "  anotherScript();\\r\\n}\"}");
        refToObjectMap.put(Long.valueOf(FixtureChromeStub.getNumber3Ref()), "{\"handle\":" + FixtureChromeStub.getNumber3Ref() + ",\"type\":\"number\",\"value\":3,\"text\":\"3\"}");
        refToObjectMap.put(Long.valueOf(FixtureChromeStub.getLongValueRef()), LongValue.createHandle(true).toJSONString());
        refToFullVersionMap.put(Long.valueOf(FixtureChromeStub.getLongValueRef()), LongValue.createHandle(false).toJSONString());
        scriptIdToScriptRefMap.put((long)FixtureChromeStub.getScriptId(), FixtureChromeStub.getScriptRef());
        scriptIdToScriptRefMap.put((long)FixtureChromeStub.getCompiledScriptId(), FixtureChromeStub.getCompiledScriptRef());
        breakpointCounter = 1L;
        seqCounter = 1L;
        NULL_BREAKPOINT_MANAGER = new BreakpointManager(null){

            public RelayOk changeBreakpoint(BreakpointImpl breakpointImpl, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
                throw new UnsupportedOperationException();
            }

            public RelayOk clearBreakpoint(BreakpointImpl breakpointImpl, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback, long originalId) {
                throw new UnsupportedOperationException();
            }

            public RelayOk setBreakpoint(Breakpoint.Target target, int line, int position, boolean enabled, String condition, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FixtureChromeStub() {
        ScriptHandle scriptsNormalBody;
        JSONObject body = this.getJsonObjectByRef(FixtureChromeStub.getScriptRef());
        try {
            scriptsNormalBody = V8ProtocolParserAccess.get().parseScriptHandle(body);
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException(e);
        }
        ScriptImplTestGate.addScript(this.scriptManager, scriptsNormalBody, this.constructScriptRefsTyped());
    }

    public static int getNumber3Ref() {
        return 65;
    }

    public static int getLongValueRef() {
        return 66;
    }

    private static int getCompiledScriptRef() {
        return 6;
    }

    public static int getFunctionRef() {
        return 0;
    }

    public static int getScriptRef() {
        return 5;
    }

    public static Long getScriptId() {
        return 566L;
    }

    public static Long getCompiledScriptId() {
        return 567L;
    }

    public static int getMouseEventRef() {
        return 1;
    }

    private static long nextBreakpointId() {
        return breakpointCounter++;
    }

    private static long nextSeq() {
        return seqCounter++;
    }

    @Override
    public Message respondTo(Message requestMessage) {
        JSONObject data;
        try {
            data = JsonUtil.jsonObjectFromJson((String)requestMessage.getContent());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        String response = null;
        boolean success = true;
        JSONObject responseMessage = new JSONObject();
        HashMap<String, Object> nameToJsonValue = new HashMap<String, Object>();
        Long seq = JsonUtil.getAsLong((JSONObject)data, (CharSequence)V8Protocol.KEY_SEQ);
        String debuggerCommandString = JsonUtil.getAsString((JSONObject)data, (CharSequence)V8Protocol.KEY_COMMAND);
        DebuggerCommand debuggerCommand = DebuggerCommand.forString((String)debuggerCommandString);
        JSONObject args = JsonUtil.getAsJSON((JSONObject)data, (CharSequence)"arguments");
        switch (debuggerCommand) {
            case LOOKUP: {
                JSONArray handles = JsonUtil.getAsJSONArray((JSONObject)args, (CharSequence)"handles");
                JSONObject jsonBody = this.putJsonValue("body", new JSONObject(), nameToJsonValue);
                int i = 0;
                while (i < handles.size()) {
                    String fullVersion;
                    Long ref = (Long)handles.get(i);
                    String objectData = refToObjectMap.get(ref);
                    if (args.get((Object)"maxStringLength") != null && (fullVersion = refToFullVersionMap.get(ref)) != null) {
                        objectData = fullVersion;
                    }
                    if (objectData != null) {
                        try {
                            jsonBody.put((Object)String.valueOf(ref), (Object)JsonUtil.jsonObjectFromJson((String)objectData));
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        success = false;
                    }
                    ++i;
                }
                JSONArray jsonRefs = this.putJsonValue("refs", new JSONArray(), nameToJsonValue);
                jsonRefs.add((Object)this.getJsonObjectByRef(FixtureChromeStub.getNumber3Ref()));
                break;
            }
            case EVALUATE: {
                success = this.handleEvaluate(args, nameToJsonValue);
                break;
            }
            case SETBREAKPOINT: 
            case CHANGEBREAKPOINT: {
                long id = debuggerCommand == DebuggerCommand.SETBREAKPOINT ? FixtureChromeStub.nextBreakpointId() : JsonUtil.getAsLong((JSONObject)args, (CharSequence)"breakpoint");
                Breakpoint.Target.ScriptName target = new Breakpoint.Target.ScriptName("abcde.js");
                this.breakpoints.put(id, new FakeBreakpoint(id, (Breakpoint.Target)target, JsonUtil.getAsBoolean((JSONObject)args, (CharSequence)"enabled"), JsonUtil.getAsString((JSONObject)args, (CharSequence)"condition")));
                JSONObject jsonBody = this.putJsonValue("body", new JSONObject(), nameToJsonValue);
                jsonBody.put((Object)"type", (Object)"script");
                jsonBody.put((Object)"breakpoint", (Object)id);
                break;
            }
            case CLEARBREAKPOINT: {
                long id = JsonUtil.getAsLong((JSONObject)args, (CharSequence)"breakpoint");
                this.breakpoints.remove(id);
                JSONObject jsonBody = this.putJsonValue("body", new JSONObject(), nameToJsonValue);
                jsonBody.put((Object)"type", (Object)"script");
                jsonBody.put((Object)"breakpoint", (Object)id);
                break;
            }
            case CONTINUE: {
                this.isRunning = true;
                break;
            }
            case BACKTRACE: {
                JSONObject jsonBody = this.putJsonValue("body", new JSONObject(), nameToJsonValue);
                this.constructBacktrace(responseMessage, jsonBody);
                break;
            }
            case SCRIPTS: {
                nameToJsonValue.put("body", this.constructScripts(JsonUtil.getAsJSONArray((JSONObject)args, (CharSequence)"ids")));
                nameToJsonValue.put("refs", this.constructScriptRefsJson());
                break;
            }
            case SOURCE: {
                break;
            }
            case SCOPE: {
                this.constructScopeResponse(nameToJsonValue);
                break;
            }
            default: {
                success = false;
            }
        }
        responseMessage.put((Object)"seq", (Object)FixtureChromeStub.nextSeq());
        responseMessage.put((Object)"request_seq", (Object)seq);
        responseMessage.put((Object)"command", (Object)debuggerCommandString);
        responseMessage.put((Object)"type", (Object)"response");
        if (success) {
            responseMessage.put((Object)"success", (Object)true);
            responseMessage.put((Object)"running", (Object)this.isRunning);
            for (Map.Entry entry : nameToJsonValue.entrySet()) {
                responseMessage.put(entry.getKey(), entry.getValue());
            }
        } else {
            responseMessage.put((Object)"success", (Object)false);
            responseMessage.put((Object)"message", (Object)"An error occurred");
        }
        response = responseMessage.toJSONString();
        return new Message(Collections.emptyMap(), response);
    }

    @Override
    public void sendSuspendedEvent() {
        String response = "{\"seq\":" + FixtureChromeStub.nextSeq() + ",\"type\":\"event\",\"event\":\"break\"," + "\"body\":{\"invocationText\":\"wasteCpu();\",\"sourceLine\":25,\"sourceColumn\":4," + "\"sourceLineText\":\"    debugger;\",\"script\":{\"id\":11,\"name\":\"samples/test.js\"," + "\"lineOffset\":0,\"columnOffset\":0,\"lineCount\":36}}}";
        Message message = new Message(Collections.emptyMap(), response);
        this.listener.messageReceived(message);
    }

    private <T> T putJsonValue(String name, T value, Map<String, Object> targetMap) {
        targetMap.put(name, value);
        return value;
    }

    private JSONArray constructScriptRefsJson() {
        return JsonBuilderUtil.jsonArray(JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("text", "#<a ContextMirror>"), JsonBuilderUtil.jsonProperty("handle", 0L), JsonBuilderUtil.jsonProperty("type", "context"), JsonBuilderUtil.jsonProperty("data", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("value", 1L), JsonBuilderUtil.jsonProperty("type", "page")))));
    }

    private List<SomeHandle> constructScriptRefsTyped() {
        JSONArray refs = this.constructScriptRefsJson();
        try {
            return FixtureParserAccess.get().parseRefs(refs).asHandles();
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONArray constructScripts(JSONArray ids) {
        JSONArray scripts = new JSONArray();
        for (Script script : this.scriptManager.allScripts()) {
            Object id = script.getId();
            if (ids != null && !ids.contains(id)) continue;
            scripts.add((Object)this.getJsonObjectByRef(scriptIdToScriptRefMap.get(script.getId())));
        }
        return scripts;
    }

    private void constructBacktrace(JSONObject response, JSONObject responseBody) {
        response.put((Object)"refs", (Object)this.getRefs(FixtureChromeStub.getScriptRef(), FixtureChromeStub.getFunctionRef()));
        responseBody.put((Object)"fromFrame", (Object)0);
        responseBody.put((Object)"toFrame", (Object)1);
        responseBody.put((Object)"totalFrames", (Object)1);
        JSONArray frames = new JSONArray();
        JSONObject frame = new JSONObject();
        frame.put((Object)"type", (Object)"frame");
        frame.put((Object)"index", (Object)0);
        frame.put((Object)"receiver", (Object)this.getReceiver());
        frame.put((Object)"func", (Object)this.getFunc());
        frame.put((Object)"script", (Object)this.getScript());
        frame.put((Object)"constructCall", (Object)false);
        frame.put((Object)"debuggerFrame", (Object)false);
        frame.put((Object)"arguments", (Object)new JSONArray());
        frame.put((Object)"locals", (Object)this.getLocalsArray());
        frame.put((Object)"scopes", (Object)this.getScopesArray());
        frame.put((Object)"position", (Object)305);
        frame.put((Object)"line", (Object)18);
        frame.put((Object)"column", (Object)3);
        frame.put((Object)"sourceLineText", (Object)"   foo = bar;");
        frame.put((Object)"text", (Object)"#00 clicked() file:///C:/1.js line 18 column 3 (position 305)");
        frames.add((Object)frame);
        responseBody.put((Object)"frames", (Object)frames);
    }

    private void constructScopeResponse(Map<String, Object> nameToJsonValue) {
        nameToJsonValue.put("body", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("type", 1), JsonBuilderUtil.jsonProperty("index", 0), JsonBuilderUtil.jsonProperty("frameIndex", 0), JsonBuilderUtil.jsonProperty("object", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("handle", -1), JsonBuilderUtil.jsonProperty("type", "object"), JsonBuilderUtil.jsonProperty("className", "Object"), JsonBuilderUtil.jsonProperty("constructorFunction", JsonBuilderUtil.jsonObject("'ref':20,'type':'function','name':'Object','inferredName':''")), JsonBuilderUtil.jsonProperty("protoObject", JsonBuilderUtil.jsonObject("'ref':21,'type':'object','className':'Object'")), JsonBuilderUtil.jsonProperty("prototypeObject", JsonBuilderUtil.jsonObject("'ref':2,'type':'undefined'")), JsonBuilderUtil.jsonProperty("properties", JsonBuilderUtil.jsonArray(JsonBuilderUtil.jsonObject("'name':'x','value':{'ref':" + FixtureChromeStub.getMouseEventRef() + ",'type':'object','className':'MouseEvent'}"), JsonBuilderUtil.jsonObject("'name':'y','value':{'ref':" + FixtureChromeStub.getNumber3Ref() + ",'type':'number','value':3}"))), JsonBuilderUtil.jsonProperty("text", "#<an Object>"))), JsonBuilderUtil.jsonProperty("text", "#<a ScopeMirror>")));
        nameToJsonValue.put("refs", this.getRefs(FixtureChromeStub.getNumber3Ref(), FixtureChromeStub.getMouseEventRef()));
    }

    private boolean handleEvaluate(JSONObject args, Map<String, Object> nameToJsonValue) {
        String expression = JsonUtil.getAsString((JSONObject)args, (CharSequence)"expression");
        if (!"#long_value".equals(expression)) {
            return false;
        }
        nameToJsonValue.put("body", LongValue.createHandle(true));
        return true;
    }

    private JSONArray getRefs(int ... refParams) {
        JSONObject[] refHandleObjects = new JSONObject[refParams.length];
        int i = 0;
        while (i < refParams.length) {
            refHandleObjects[i] = this.getJsonObjectByRef(refParams[i]);
            ++i;
        }
        return JsonBuilderUtil.jsonArray(refHandleObjects);
    }

    private JSONObject getJsonObjectByRef(int ref) {
        String jsonText = refToObjectMap.get(ref);
        try {
            return JsonUtil.jsonObjectFromJson((String)jsonText);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONArray getLocalsArray() {
        return JsonBuilderUtil.jsonArray(JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("name", "a"), JsonBuilderUtil.jsonProperty("value", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("ref", FixtureChromeStub.getNumber3Ref()), JsonBuilderUtil.jsonProperty("type", "number"), JsonBuilderUtil.jsonProperty("value", 1)))));
    }

    private JSONArray getScopesArray() {
        return JsonBuilderUtil.jsonArray(JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("type", 0), JsonBuilderUtil.jsonProperty("index", 0)));
    }

    private JSONObject getScript() {
        JSONObject script = new JSONObject();
        script.put((Object)"ref", (Object)FixtureChromeStub.getScriptRef());
        return script;
    }

    private JSONObject getFunc() {
        JSONObject func = new JSONObject();
        func.put((Object)"ref", (Object)FixtureChromeStub.getFunctionRef());
        func.put((Object)"type", (Object)"function");
        func.put((Object)"name", (Object)"clicked");
        func.put((Object)"scriptId", (Object)FixtureChromeStub.getScriptId());
        return func;
    }

    private JSONObject getReceiver() {
        JSONObject receiver = new JSONObject();
        receiver.put((Object)"ref", (Object)FixtureChromeStub.getMouseEventRef());
        receiver.put((Object)"type", (Object)"object");
        receiver.put((Object)"className", (Object)"global");
        return receiver;
    }

    public void sendEvent(Message eventMessage) {
        this.listener.messageReceived(eventMessage);
    }

    public void hitBreakpoints(Collection<Long> breakpointIds) {
        this.isRunning = false;
        JSONObject eventObject = new JSONObject();
        eventObject.put((Object)"seq", (Object)FixtureChromeStub.nextSeq());
        eventObject.put((Object)"type", (Object)"event");
        eventObject.put((Object)"event", (Object)"break");
        JSONObject body = new JSONObject();
        JSONArray bps = new JSONArray();
        bps.addAll(breakpointIds);
        body.put((Object)"breakpoints", (Object)bps);
        eventObject.put((Object)"body", (Object)body);
        this.sendEvent(this.createMessage(eventObject.toJSONString()));
    }

    public void sendAfterCompile() {
        ScriptHandle scriptsNormalBody;
        JSONObject scriptsObject = this.getJsonObjectByRef(FixtureChromeStub.getCompiledScriptRef());
        try {
            scriptsNormalBody = V8ProtocolParserAccess.get().parseScriptHandle(scriptsObject);
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException(e);
        }
        ScriptImplTestGate.addScript(this.scriptManager, scriptsNormalBody, this.constructScriptRefsTyped());
        JSONObject scriptObject = this.getJsonObjectByRef(FixtureChromeStub.getCompiledScriptRef());
        scriptObject.remove((Object)"source");
        JSONObject afterCompileObject = JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("seq", FixtureChromeStub.nextSeq()), JsonBuilderUtil.jsonProperty("type", "event"), JsonBuilderUtil.jsonProperty("event", "afterCompile"), JsonBuilderUtil.jsonProperty("success", true), JsonBuilderUtil.jsonProperty("body", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("script", scriptObject))), JsonBuilderUtil.jsonProperty("refs", this.constructScriptRefsJson()));
        this.sendEvent(this.createMessage(afterCompileObject.toJSONString()));
    }

    private Message createMessage(String content) {
        return new Message(Collections.emptyMap(), content);
    }

    @Override
    public void setNetListener(Connection.NetListener listener) {
        this.listener = listener;
    }

    private static class FakeBreakpoint
    extends BreakpointImpl {
        public FakeBreakpoint(long id, Breakpoint.Target target, boolean enabled, String condition) {
            super(id, target, 15L, enabled, condition, NULL_BREAKPOINT_MANAGER);
        }
    }

    @JsonParserRoot
    public static interface FixtureParser {
        @JsonParseMethod
        public Refs parseRefs(Object var1) throws JsonProtocolParseException;
    }

    private static class LongValue {
        static final String FULL_VALUE = "A very very very very very very very long value";
        static final int LENGTH_LIMIT = 10;

        private LongValue() {
        }

        static JSONObject createHandle(boolean truncated) {
            if (truncated) {
                String truncatedValue = String.valueOf(FULL_VALUE.substring(0, 10)) + " ...";
                return JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("handle", FixtureChromeStub.getLongValueRef()), JsonBuilderUtil.jsonProperty("type", "string"), JsonBuilderUtil.jsonProperty("value", truncatedValue), JsonBuilderUtil.jsonProperty("text", truncatedValue), JsonBuilderUtil.jsonProperty("fromIndex", 0), JsonBuilderUtil.jsonProperty("toIndex", 10), JsonBuilderUtil.jsonProperty("length", FULL_VALUE.length()));
            }
            return JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("handle", FixtureChromeStub.getLongValueRef()), JsonBuilderUtil.jsonProperty("type", "string"), JsonBuilderUtil.jsonProperty("value", FULL_VALUE), JsonBuilderUtil.jsonProperty("text", FULL_VALUE));
        }
    }

    @JsonType(subtypesChosenManually=true)
    public static interface Refs {
        @JsonSubtypeCasting
        public List<SomeHandle> asHandles() throws JsonProtocolParseException;

        @JsonSubtypeCasting
        public List<? extends SomeHandle> asHandles2() throws JsonProtocolParseException;
    }
}

