/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.HashSet;

public final class CheckDuplicateCase
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType DUPLICATE_CASE = DiagnosticType.warning("JSC_DUPLICATE_CASE", "Duplicate case in a switch statement.");
    private final AbstractCompiler compiler;

    public CheckDuplicateCase(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isSwitch()) {
            HashSet<String> cases = new HashSet<String>();
            for (Node curr = n.getSecondChild(); curr != null; curr = curr.getNext()) {
                String source = this.compiler.toSource(curr.getFirstChild());
                if (cases.add(source)) continue;
                t.report(curr, DUPLICATE_CASE, new String[0]);
            }
        }
    }
}

