/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;

public class EclipseLinkDynamicEntityField {
    private static final String DOT = ".";
    private static final char BRACKET_SQUARE = '[';
    private static final char BRACKET_ANGULAR = '<';
    private static final String PACKAGE_JAVA_LANG = "java.lang.";
    private MappingUiDefinition mappingType;
    private String name = "";
    private String attributeType;
    private String fqnAttributeType;
    private String targetType;
    private String fqnTargetType;
    private boolean key = false;
    private static final String[] PK_TYPES = new String[]{"int", "long", "short", "char", "boolean", "byte", "double", "float", "java.lang.String", "java.sql.Date", "java.util.Date", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Character", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float"};
    private static final String[] PK_TYPES_SHORT = new String[]{"String", "Integer", "Long", "Short", "Character", "Boolean", "Byte", "Double", "Float"};
    private static final List<String> VALID_PK_TYPES = Arrays.asList(PK_TYPES);
    private static final List<String> VALID_PK_TYPES_SHORT = Arrays.asList(PK_TYPES_SHORT);

    public MappingUiDefinition getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingUiDefinition mappingType) {
        this.mappingType = mappingType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(String type) {
        this.attributeType = type;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String type) {
        this.targetType = type;
    }

    public String getFqnAttributeType() {
        return this.fqnAttributeType;
    }

    public void setFqnAttributeType(String fqnTypeName) {
        String fqnBasicTypeName = this.getBasicFQN(fqnTypeName = this.removeSpaces(fqnTypeName));
        if (fqnBasicTypeName.indexOf(DOT) == -1) {
            if (VALID_PK_TYPES_SHORT.contains(fqnBasicTypeName)) {
                this.fqnAttributeType = PACKAGE_JAVA_LANG + fqnTypeName;
                this.setAttributeType(fqnTypeName);
            } else {
                this.fqnAttributeType = fqnTypeName;
                this.setAttributeType(fqnTypeName);
            }
        } else {
            this.fqnAttributeType = fqnTypeName;
            this.setAttributeType(this.getSimpleName(fqnTypeName));
        }
    }

    public String getFqnTargetType() {
        return this.fqnTargetType;
    }

    public void setFqnTargetType(String fqnTypeName) {
        String fqnBasicTypeName = this.getBasicFQN(fqnTypeName = this.removeSpaces(fqnTypeName));
        if (fqnBasicTypeName.indexOf(DOT) == -1) {
            if (VALID_PK_TYPES_SHORT.contains(fqnBasicTypeName)) {
                this.fqnTargetType = PACKAGE_JAVA_LANG + fqnTypeName;
                this.setTargetType(fqnTypeName);
            } else {
                this.fqnTargetType = fqnTypeName;
                this.setTargetType(fqnTypeName);
            }
        } else {
            this.fqnTargetType = fqnTypeName;
            this.setTargetType(this.getSimpleName(fqnTypeName));
        }
    }

    private String removeSpaces(String str) {
        str = str.trim();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private String getBasicFQN(String fqn) {
        int bsIndex = fqn.indexOf(91);
        int baIndex = fqn.indexOf(60);
        String res = bsIndex == -1 ? (baIndex == -1 ? fqn : fqn.substring(0, baIndex)) : (baIndex == -1 ? fqn.substring(0, bsIndex) : fqn.substring(0, Math.max(bsIndex, baIndex)));
        return res;
    }

    private String getSimpleName(String fullyName) {
        return fullyName.substring(fullyName.lastIndexOf(DOT) + 1);
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean couldTypeBePKType() {
        boolean result = false;
        result = VALID_PK_TYPES.contains(this.getFqnAttributeType());
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fqnAttributeType == null ? 0 : this.fqnAttributeType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.mappingType == null ? 0 : this.mappingType.hashCode());
        result = 31 * result + (this.fqnTargetType == null ? 0 : this.fqnTargetType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EclipseLinkDynamicEntityField other = (EclipseLinkDynamicEntityField)obj;
        if (this.fqnAttributeType == null ? other.fqnAttributeType != null : !this.fqnAttributeType.equals(other.fqnAttributeType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.mappingType == null ? other.mappingType != null : !this.mappingType.equals(other.mappingType)) {
            return false;
        }
        return !(this.fqnTargetType == null ? other.fqnTargetType != null : !this.fqnTargetType.equals(other.fqnTargetType));
    }
}

