/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTAnnotatedElement;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTModifiedDeclaration;
import org.eclipse.jpt.common.core.utility.jdt.AbstractType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.command.CommandContext;

public abstract class JDTMember
extends JDTAnnotatedElement
implements Member {
    private final AbstractType declaringType;
    private final int occurrence;

    protected JDTMember(AbstractType declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext) {
        this(declaringType, name, occurrence, compilationUnit, modifySharedDocumentCommandContext, DefaultAnnotationEditFormatter.instance());
    }

    protected JDTMember(AbstractType declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext, AnnotationEditFormatter annotationEditFormatter) {
        super(name, compilationUnit, modifySharedDocumentCommandContext, annotationEditFormatter);
        this.declaringType = declaringType;
        this.occurrence = occurrence;
    }

    public abstract BodyDeclaration getBodyDeclaration(CompilationUnit var1);

    @Override
    public ModifiedDeclaration getModifiedDeclaration(CompilationUnit astRoot) {
        return new JDTModifiedDeclaration(this.getBodyDeclaration(astRoot));
    }

    @Override
    public boolean matches(String memberName, int occur) {
        return memberName.equals(this.getName()) && occur == this.occurrence;
    }

    protected int getOccurrence() {
        return this.occurrence;
    }

    protected AbstractType getDeclaringType() {
        return this.declaringType;
    }
}

