/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.WSPluginMessages;
import org.eclipse.jst.ws.internal.conformance.IJavaBeanProperty;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRuleEngine;
import org.eclipse.jst.ws.internal.conformance.JDTResolver;
import org.eclipse.jst.ws.internal.conformance.JavaWebServiceRuleSet;
import org.eclipse.osgi.util.NLS;

public class JAXRPCWebServiceRuleEngine
implements IJavaWebServiceRuleEngine {
    private JDTResolver resolver_;
    private IProgressMonitor progressMonitor_;
    private Set visited_;
    private Stack peanutTrail_;

    public JAXRPCWebServiceRuleEngine(IProgressMonitor progressMonitor) {
        this.progressMonitor_ = progressMonitor;
    }

    @Override
    public IStatus analyze(IProject project, IType rootClass, JavaWebServiceRuleSet rules) {
        this.visited_ = new HashSet();
        this.peanutTrail_ = new Stack();
        this.resolver_ = new JDTResolver(project, this.progressMonitor_);
        Status status = null;
        rules.init(this);
        try {
            this.analyzeServiceClass(rootClass, rules);
            String inCaseOfFailureMessage = NLS.bind((String)WSPluginMessages.MSG_JAXRPC11_NOT_COMPLIANT, (Object)rootClass.getFullyQualifiedName());
            status = rules.getResults(inCaseOfFailureMessage);
        }
        catch (JavaModelException e) {
            status = new Status(4, "org.eclipse.jst.ws", 0, "Internal Error", (Throwable)e);
        }
        return status;
    }

    private void analyzeServiceClass(IType type, JavaWebServiceRuleSet rules) throws JavaModelException {
        rules.visitClass(type, this.peanutTrail_);
        this.visited_.add(type.getFullyQualifiedName());
        this.push(type);
        try {
            IType[] superClasses = this.resolver_.getSuperClasses(type);
            IMethod[] methods = this.resolver_.getPublicMethods(type, superClasses);
            int m = 0;
            while (m < methods.length) {
                this.analyzeMethod(methods[m], rules);
                ++m;
            }
        }
        finally {
            this.pop();
        }
    }

    private void analyzeMethod(IMethod method, JavaWebServiceRuleSet rules) throws JavaModelException {
        rules.visitMethod(method, this.peanutTrail_);
        this.push(method);
        try {
            IType returnType = this.resolver_.getReturnType(method);
            this.analyzeDataType(returnType, rules);
            IType[] parameterTypes = this.resolver_.getParameterTypes(method);
            int p = 0;
            while (p < parameterTypes.length) {
                this.analyzeDataType(parameterTypes[p], rules);
                ++p;
            }
            IType[] exceptionTypes = this.resolver_.getExceptionTypes(method);
            int e = 0;
            while (e < exceptionTypes.length) {
                this.analyzeExceptionType(exceptionTypes[e], rules);
                ++e;
            }
        }
        finally {
            this.pop();
        }
    }

    private void analyzeDataType(IType type, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (type != null && !this.resolver_.isStandardType(type.getFullyQualifiedName()) && !this.visited_.contains(type.getFullyQualifiedName())) {
            rules.visitClass(type, this.peanutTrail_);
            this.visited_.add(type.getFullyQualifiedName());
            this.push(type);
            try {
                IType[] superClasses = this.resolver_.getSuperClasses(type);
                IField[] fields = this.resolver_.getPublicFields(type, superClasses);
                int f = 0;
                while (f < fields.length) {
                    this.analyzeField(fields[f], rules);
                    ++f;
                }
                IJavaBeanProperty[] properties = this.resolver_.getPublicProperties(type, superClasses);
                int p = 0;
                while (p < properties.length) {
                    this.analyzeProperty(properties[p], rules);
                    ++p;
                }
            }
            finally {
                this.pop();
            }
        }
    }

    private void analyzeField(IField field, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (field != null) {
            rules.visitField(field, this.peanutTrail_);
            this.push(field);
            try {
                IType type = this.resolver_.getFieldType(field);
                this.analyzeDataType(type, rules);
            }
            finally {
                this.pop();
            }
        }
    }

    private void analyzeProperty(IJavaBeanProperty property, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (property != null) {
            rules.visitProperty(property, this.peanutTrail_);
            this.push(property);
            try {
                IType type = this.resolver_.getPropertyType(property);
                this.analyzeDataType(type, rules);
            }
            finally {
                this.pop();
            }
        }
    }

    private void analyzeExceptionType(IType type, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (type != null && !this.resolver_.isStandardType(type.getFullyQualifiedName()) && !this.visited_.contains(type.getFullyQualifiedName())) {
            rules.visitException(type, this.peanutTrail_);
            this.visited_.add(type.getFullyQualifiedName());
            this.push(type);
            try {
                IType[] superClasses = this.resolver_.getSuperClasses(type, "java.lang.Exception");
                IJavaBeanProperty[] properties = this.resolver_.getPublicProperties(type, superClasses);
                int p = 0;
                while (p < properties.length) {
                    this.analyzeProperty(properties[p], rules);
                    ++p;
                }
            }
            finally {
                this.pop();
            }
        }
    }

    @Override
    public JDTResolver getJDTResolver() {
        return this.resolver_;
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor_;
    }

    private void push(Object peanut) {
        this.peanutTrail_.push(peanut);
    }

    private void pop() {
        this.peanutTrail_.pop();
    }
}

