/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.debug.internal.crossfire.event.CFEventQueue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.osgi.framework.BundleContext;

public class CrossFirePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.jsdt.debug.crossfire";
    public static final String TRC_PACKETS = "org.eclipse.wst.jsdt.debug.crossfire/packets";
    public static final String TRC_EVENTQUEUE = "org.eclipse.wst.jsdt.debug.crossfire/eventqueue";
    public static final String TRC_JSDI = "org.eclipse.wst.jsdt.debug.crossfire/jsdi";
    public static final String TRC_JSON = "org.eclipse.wst.jsdt.debug.crossfire/json";
    public static final int INTERNAL_ERROR = 120;
    private static CrossFirePlugin plugin = null;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.configureTracing();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            plugin = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    public static CrossFirePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        CrossFirePlugin.log(CrossFirePlugin.newErrorStatus("Error logged from Crossfire Debug: ", t));
    }

    public static void logErrorMessage(String message) {
        CrossFirePlugin.log(CrossFirePlugin.newErrorStatus("Internal message logged from Crossfire Debug: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    public void configureTracing() {
        if (CrossFirePlugin.getDefault().isDebugging()) {
            String option = Platform.getDebugOption((String)TRC_PACKETS);
            if (option != null) {
                CFPacket.setTracing(Boolean.valueOf(option));
            }
            if ((option = Platform.getDebugOption((String)TRC_EVENTQUEUE)) != null) {
                CFEventQueue.setTracing(Boolean.valueOf(option));
            }
            if ((option = Platform.getDebugOption((String)TRC_JSDI)) != null) {
                CFMirror.setTracing(Boolean.valueOf(option));
            }
            if ((option = Platform.getDebugOption((String)TRC_JSON)) != null) {
                JSON.setTracing(Boolean.valueOf(option));
            }
        }
    }

    public static URI fileURI(IPath path) throws URISyntaxException {
        return new URI("file", null, path.makeAbsolute().toString(), null);
    }
}

