/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.dnd;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.navigator.ui.Messages;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.navigator.internal.dnd.AddProjectToEARDropAssistant;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ImportJ2EEModuleDropAssistant
extends AddProjectToEARDropAssistant {
    @Override
    public boolean isSupportedType(TransferData aTransferType) {
        return FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    @Override
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, final DropTargetEvent aDropTargetEvent, final Object aTarget) {
        if (FileTransfer.getInstance().isSupportedType(aDropAdapter.getCurrentTransfer())) {
            final Shell shell = this.getShell();
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            Job importArtifactsJob = new Job(Messages.ImportJ2EEModuleDropAssistant_Importing_Java_Enterprise_Edition_artifacts){

                protected IStatus run(IProgressMonitor monitor) {
                    IProject targetEARProject = ImportJ2EEModuleDropAssistant.getProject(aTarget);
                    if (targetEARProject != null && !ImportJ2EEModuleDropAssistant.this.hasEarFacet(targetEARProject)) {
                        targetEARProject = null;
                    }
                    String[] names = (String[])aDropTargetEvent.data;
                    monitor.beginTask(Messages.ImportJ2EEModuleDropAssistant_Importing_Java_Enterprise_Edition_artifacts, names.length);
                    MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee.navigator.ui", 0, Messages.ImportJ2EEModuleDropAssistant_Importing_Java_Enterprise_Edition_artifacts, null);
                    SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
                    IDataModel importDataModel = null;
                    boolean performSimpleJarCopy = false;
                    ArrayList<String> simpleJarsToCopyList = null;
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    ArrayList<Object> createdComponents = new ArrayList<Object>();
                    int i = 0;
                    while (i < names.length && !monitor.isCanceled()) {
                        block33: {
                            try {
                                String extension;
                                importDataModel = null;
                                performSimpleJarCopy = false;
                                int separatorIndex = names[i].lastIndexOf(File.separatorChar);
                                int dotIndex = names[i].lastIndexOf(46);
                                if (separatorIndex <= 0 || separatorIndex + 1 >= dotIndex) break block33;
                                String filename = names[i].substring(separatorIndex + 1, dotIndex);
                                if (root.getProject(filename).exists()) {
                                    filename = ImportJ2EEModuleDropAssistant.this.calculateValidProjectName(filename);
                                }
                                if (".war".equals(extension = names[i].substring(dotIndex))) {
                                    importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentImportDataModelProvider());
                                } else if (".rar".equals(extension)) {
                                    importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentImportDataModelProvider());
                                } else if (".ear".equals(extension)) {
                                    importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
                                } else if (".jar".equals(extension)) {
                                    try (Archive archive = null;){
                                        archive = CommonarchiveFactory.eINSTANCE.openArchive(names[i]);
                                        if (archive.isApplicationClientFile()) {
                                            importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentImportDataModelProvider());
                                        } else if (archive.isEJBJarFile()) {
                                            importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentImportDataModelProvider());
                                        } else {
                                            performSimpleJarCopy = true;
                                            if (simpleJarsToCopyList == null) {
                                                simpleJarsToCopyList = new ArrayList<String>();
                                                simpleJarsToCopyList.add(names[i]);
                                            }
                                        }
                                    }
                                }
                                if (importDataModel != null) {
                                    importDataModel.setStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", names[i]);
                                    importDataModel.setStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", filename);
                                    importDataModel.getDefaultOperation().execute((IProgressMonitor)submonitor, null);
                                    createdComponents.add(importDataModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT"));
                                } else if (!performSimpleJarCopy) {
                                    status.add(J2EENavigatorPlugin.createErrorStatus(0, NLS.bind((String)Messages.ImportJ2EEModuleDropAssistant_Could_not_recognize_extension_0_, (Object)extension), null));
                                }
                            }
                            catch (Throwable e) {
                                String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                                status.add(J2EENavigatorPlugin.createErrorStatus(0, msg, e));
                            }
                        }
                        ++i;
                    }
                    if (targetEARProject != null) {
                        String msg;
                        ArrayList<IProject> createdModuleProjects = new ArrayList<IProject>();
                        int i2 = 0;
                        while (i2 < createdComponents.size()) {
                            IVirtualComponent component = (IVirtualComponent)createdComponents.get(i2);
                            if (!ImportJ2EEModuleDropAssistant.this.hasEarFacet(component.getProject())) {
                                createdModuleProjects.add(component.getProject());
                            }
                            ++i2;
                        }
                        IDataModel dataModel = ImportJ2EEModuleDropAssistant.this.getAddModuleDataModel(targetEARProject, createdModuleProjects);
                        IDataModelOperation dropOperation = dataModel.getDefaultOperation();
                        IStatus addProjectsStatus = null;
                        try {
                            addProjectsStatus = dropOperation.execute(monitor, null);
                            if (addProjectsStatus != null) {
                                status.add(addProjectsStatus);
                            }
                        }
                        catch (ExecutionException e) {
                            msg = e.getMessage() != null ? e.getMessage() : e.toString();
                            status.add(J2EENavigatorPlugin.createErrorStatus(0, msg, null));
                        }
                        if (simpleJarsToCopyList != null) {
                            try {
                                String[] jarsToCopyArray = new String[simpleJarsToCopyList.size()];
                                simpleJarsToCopyList.toArray(jarsToCopyArray);
                                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
                                operation.copyFilesInCurrentThread(jarsToCopyArray, (IContainer)targetEARProject, monitor);
                            }
                            catch (Throwable e) {
                                msg = e.getMessage() != null ? e.getMessage() : e.toString();
                                status.add(J2EENavigatorPlugin.createErrorStatus(0, msg, e));
                            }
                        }
                    }
                    return status;
                }
            };
            service.showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), importArtifactsJob);
            importArtifactsJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            importArtifactsJob.schedule();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IStatus status = Status.CANCEL_STATUS;
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            IProject project = null;
            if (target instanceof IWorkspaceRoot) {
                status = Status.OK_STATUS;
            } else {
                project = ImportJ2EEModuleDropAssistant.getProject(target);
                if (project != null && this.hasEarFacet(project)) {
                    status = Status.OK_STATUS;
                }
            }
        }
        return status;
    }
}

