/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.Collection;
import java.util.SortedMap;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.internal.BrowserFactoryImplTestGate;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.FixtureChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.StubListener;
import org.eclipse.wst.jsdt.chromium.internal.standalonev8.StandaloneVmImpl;
import org.eclipse.wst.jsdt.chromium.internal.transport.ChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.eclipse.wst.jsdt.chromium.internal.v8native.CallFrameImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FrameObject;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8ProtocolParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsArrayImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.tests.internal.JsonBuilderUtil;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsArrayImplTest {
    private ChromeStub messageResponder;
    private CallFrameImpl callFrame;
    private ValueMirror arrayMirror;
    private final StubListener listener = new StubListener();

    @Before
    public void setUpBefore() throws Exception {
        this.messageResponder = new FixtureChromeStub();
        StandaloneVmImpl standaloneVm = BrowserFactoryImplTestGate.createStandalone(new FakeConnection(this.messageResponder), FakeConnection.HANDSHAKER);
        standaloneVm.attach((DebugEventListener)this.listener);
        this.listener.expectSuspendedEvent();
        this.messageResponder.sendSuspendedEvent();
        DebugContext debugContext = this.listener.getDebugContext();
        String propertyRefText = "{'ref':" + FixtureChromeStub.getNumber3Ref() + ",'type':'number','value':3,'text':'3'}";
        InternalContext internalContext = ContextBuilder.getInternalContextForTests((DebugContext)debugContext);
        String valueHandleJsonText = ("{'protoObject':{'ref':55516,'className':'Array','type':'object'},'text':'#<an Array>','handle':5559,'constructorFunction':{'ref':55515,'inferredName':'','name':'Array','type':'function'},'prototypeObject':{'ref':5553,'type':'undefined'},'className':'Array','properties':[{'name':'length','value':{'ref':55517,'value':2,'type':'number'}},{'name':1,'value':" + propertyRefText + "}," + "{'name':3,'value':" + propertyRefText + "}],'type':'object'}").replace('\'', '\"');
        JSONObject valueHandleJson = (JSONObject)JSONValue.parse((String)valueHandleJsonText);
        ValueHandle valueHandle = V8ProtocolParserAccess.get().parseValueHandle(valueHandleJson);
        this.arrayMirror = internalContext.getValueLoader().addDataToMap(valueHandle);
        String proptoHandleJsonText = "{'text':'#<an Object>', 'handle':55516,'className':'Object','type':'object'}".replace('\'', '\"');
        JSONObject protoHandleJson = (JSONObject)JSONValue.parse((String)proptoHandleJsonText);
        ValueHandle protoHandle = V8ProtocolParserAccess.get().parseValueHandle(protoHandleJson);
        internalContext.getValueLoader().addDataToMap(protoHandle);
        JSONObject jsonObject = JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("line", 12L), JsonBuilderUtil.jsonProperty("index", 0L), JsonBuilderUtil.jsonProperty("sourceLineText", ""), JsonBuilderUtil.jsonProperty("script", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("ref", (long)FixtureChromeStub.getScriptId()))), JsonBuilderUtil.jsonProperty("func", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("name", "foofunction"))));
        FrameObject frameObject = V8ProtocolParserAccess.get().parseFrameObject(jsonObject);
        this.callFrame = new CallFrameImpl(frameObject, internalContext);
    }

    @Test
    public void testArrayData() throws Exception {
        JsArrayImpl jsArray = new JsArrayImpl((ValueLoader)this.callFrame.getInternalContext().getValueLoader(), this.arrayMirror);
        Assert.assertNotNull((Object)jsArray.asArray());
        Collection properties = jsArray.getProperties();
        Assert.assertEquals((long)3L, (long)properties.size());
        Assert.assertEquals((long)4L, (long)jsArray.getLength());
        SortedMap sparseArray = jsArray.toSparseArray();
        Assert.assertEquals((long)2L, (long)sparseArray.size());
        JsVariable firstElement = (JsVariable)sparseArray.get(1L);
        JsVariable thirdElement = (JsVariable)sparseArray.get(3L);
        Assert.assertNull((Object)jsArray.get(-1L));
        Assert.assertNull((Object)jsArray.get(0L));
        Assert.assertEquals((Object)firstElement, (Object)jsArray.get(1L));
        Assert.assertEquals((Object)"1", (Object)firstElement.getName());
        Assert.assertNull((Object)jsArray.get(2L));
        Assert.assertEquals((Object)thirdElement, (Object)jsArray.get(3L));
        Assert.assertEquals((Object)"3", (Object)thirdElement.getName());
        Assert.assertNull((Object)jsArray.get(10L));
        JsArrayImplTest.checkElementData(firstElement);
        JsArrayImplTest.checkElementData(thirdElement);
    }

    private static void checkElementData(JsVariable arrayElement) {
        Assert.assertNotNull((Object)arrayElement);
        JsValue value = arrayElement.getValue();
        Assert.assertEquals((Object)JsValue.Type.TYPE_NUMBER, (Object)value.getType());
        Assert.assertEquals((Object)"3", (Object)value.getValueString());
    }
}

