/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateWrapper;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class PredicateWrapperTests
extends TestCase {
    private Predicate<Integer> wrappedPredicate;
    private PredicateWrapper<Integer> predicateWrapper;

    public PredicateWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedPredicate = PredicateTools.isEqual((Object)42);
        this.predicateWrapper = PredicateTools.wrap(this.wrappedPredicate);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        PredicateWrapperTests.assertTrue((boolean)this.predicateWrapper.evaluate((Object)new Integer(42)));
        PredicateWrapperTests.assertTrue((boolean)this.predicateWrapper.evaluate((Object)42));
        PredicateWrapperTests.assertTrue((boolean)this.predicateWrapper.evaluate((Object)Integer.valueOf("42")));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate(null));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate((Object)24));
        this.predicateWrapper.setPredicate(PredicateTools.isEqual((Object)13));
        PredicateWrapperTests.assertTrue((boolean)this.predicateWrapper.evaluate((Object)new Integer(13)));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate((Object)new Integer(42)));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate((Object)42));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate((Object)Integer.valueOf("42")));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate(null));
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.evaluate((Object)24));
    }

    public void testEquals() {
        PredicateWrapper predicateWrapper2 = PredicateTools.wrap(this.wrappedPredicate);
        PredicateWrapperTests.assertEquals(this.predicateWrapper, (Object)predicateWrapper2);
        PredicateWrapperTests.assertEquals((int)this.predicateWrapper.hashCode(), (int)predicateWrapper2.hashCode());
        PredicateWrapperTests.assertFalse((boolean)this.predicateWrapper.equals((Object)IsNotNull.instance()));
    }
}

