/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.ImageDescriptorRegistry;
import org.osgi.framework.Bundle;

public final class RhinoImageRegistry {
    private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry descRegistry;
    private static String ICONS_PATH;
    static final String ELCL;
    static final String OVR;
    static final String DLCL;

    static {
        ICONS_PATH = "$nl$/icons/";
        ELCL = String.valueOf(ICONS_PATH) + "elcl16/";
        OVR = String.valueOf(ICONS_PATH) + "ovr16/";
        DLCL = String.valueOf(ICONS_PATH) + "dlcl16/";
    }

    private static void declareImages() {
        RhinoImageRegistry.declareRegistryImage("IMG_SCRIPT", String.valueOf(ELCL) + "script.gif");
        RhinoImageRegistry.declareRegistryImage("IMG_RHINO", String.valueOf(ELCL) + "rhino.gif");
        RhinoImageRegistry.declareRegistryImage("IMG_MAIN_TAB", String.valueOf(ELCL) + "main_tab.gif");
        RhinoImageRegistry.declareRegistryImage("IMG_LIBRARY", String.valueOf(ELCL) + "library.gif");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.jsdt.debug.rhino.ui");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }

    public static Image getSharedImage(String key) {
        if (imageRegistry == null) {
            RhinoImageRegistry.initializeImageRegistry();
        }
        return imageRegistry.get(key);
    }

    private static synchronized ImageRegistry initializeImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            RhinoImageRegistry.declareImages();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor descriptor) {
        if (descRegistry == null) {
            descRegistry = new ImageDescriptorRegistry();
        }
        return descRegistry.get(descriptor);
    }

    public static void dispose() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
        }
        if (descRegistry != null) {
            descRegistry.dispose();
        }
    }

    private RhinoImageRegistry() {
    }
}

