/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.IgnoreCountBreakpointExtension;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.ScriptRegExpBreakpointTarget;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.LocationValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.SetBreakpointByUrlData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.SetBreakpointData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParamsWithResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.LocationParam;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.RemoveBreakpointParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.SetBreakpointByUrlParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.SetBreakpointParams;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class WipBreakpointImpl
implements Breakpoint {
    private final WipBreakpointManager breakpointManager;
    private final Breakpoint.Target target;
    private final int lineNumber;
    private final int columnNumber;
    private final int sdkId;
    private volatile String protocolId = null;
    private volatile String condition;
    private volatile boolean enabled;
    private volatile boolean isDirty;
    private Set<ActualLocation> actualLocations = new HashSet<ActualLocation>(2);
    public static final BreakpointTypeExtension TYPE_EXTENSION = new BreakpointTypeExtension(){
        private final BreakpointTypeExtension.ScriptRegExpSupport scriptRegExpSupport = new BreakpointTypeExtension.ScriptRegExpSupport(){

            public Breakpoint.Target createTarget(String regExp) {
                return new ScriptRegExpBreakpointTarget(regExp);
            }
        };

        public BreakpointTypeExtension.FunctionSupport getFunctionSupport() {
            return null;
        }

        public BreakpointTypeExtension.ScriptRegExpSupport getScriptRegExpSupport() {
            return this.scriptRegExpSupport;
        }
    };

    public WipBreakpointImpl(WipBreakpointManager breakpointManager, int sdkId, Breakpoint.Target target, int lineNumber, int columnNumber, String condition, boolean enabled) {
        this.breakpointManager = breakpointManager;
        this.sdkId = sdkId;
        this.target = target;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.condition = condition;
        this.enabled = enabled;
        this.isDirty = false;
    }

    public Breakpoint.Target getTarget() {
        return this.target;
    }

    public long getId() {
        return this.sdkId;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        this.isDirty = true;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        if (WipBreakpointImpl.eq(this.condition, condition)) {
            return;
        }
        this.condition = condition;
        this.isDirty = true;
    }

    public IgnoreCountBreakpointExtension getIgnoreCountBreakpointExtension() {
        return WipBreakpointImpl.getIgnoreCountBreakpointExtensionImpl();
    }

    public static IgnoreCountBreakpointExtension getIgnoreCountBreakpointExtensionImpl() {
        return null;
    }

    void setRemoteData(String protocolId, Collection<ActualLocation> actualLocations) {
        this.protocolId = protocolId;
        this.actualLocations.clear();
        this.actualLocations.addAll(actualLocations);
        this.breakpointManager.getDb().setIdMapping(this, protocolId);
    }

    void addResolvedLocation(LocationValue locationValue) {
        ActualLocation location = WipBreakpointImpl.locationFromProtocol(locationValue);
        this.actualLocations.add(location);
    }

    Set<ActualLocation> getActualLocations() {
        return this.actualLocations;
    }

    void clearActualLocations() {
        this.actualLocations.clear();
    }

    void deleteSelfFromDb() {
        if (this.protocolId != null) {
            this.breakpointManager.getDb().setIdMapping(this, null);
        }
        this.breakpointManager.getDb().removeBreakpoint(this);
    }

    public RelayOk clear(final JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        if (this.protocolId == null) {
            this.breakpointManager.getDb().removeBreakpoint(this);
            callback.success((Breakpoint)this);
            return RelaySyncCallback.finish((SyncCallback)syncCallback);
        }
        RemoveBreakpointParams params = new RemoveBreakpointParams(this.protocolId);
        WipCommandCallback.Default commandCallback = callback == null ? null : new WipCommandCallback.Default(){

            @Override
            protected void onSuccess(WipCommandResponse.Success success) {
                WipBreakpointImpl.this.breakpointManager.getDb().setIdMapping(WipBreakpointImpl.this, null);
                WipBreakpointImpl.this.breakpointManager.getDb().removeBreakpoint(WipBreakpointImpl.this);
                callback.success((Breakpoint)WipBreakpointImpl.this);
            }

            @Override
            protected void onError(String message) {
                callback.failure(message);
            }
        };
        return this.breakpointManager.getCommandProcessor().send(params, commandCallback, syncCallback);
    }

    public RelayOk flush(final JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        final RelaySyncCallback relay = new RelaySyncCallback(syncCallback);
        if (!this.isDirty) {
            if (callback != null) {
                callback.success((Breakpoint)this);
            }
            return RelaySyncCallback.finish((SyncCallback)syncCallback);
        }
        this.isDirty = false;
        if (this.protocolId == null) {
            return this.recreateBreakpointAsync(callback, relay);
        }
        final RelaySyncCallback.Guard guard = relay.newGuard();
        WipCommandCallback.Default removeCallback = new WipCommandCallback.Default(){

            @Override
            protected void onSuccess(WipCommandResponse.Success success) {
                WipBreakpointImpl.this.setRemoteData(null, Collections.emptyList());
                RelayOk relayOk = WipBreakpointImpl.this.recreateBreakpointAsync(callback, relay);
                guard.discharge(relayOk);
            }

            @Override
            protected void onError(String message) {
                throw new RuntimeException("Failed to remove breakpoint: " + message);
            }
        };
        return this.breakpointManager.getCommandProcessor().send(new RemoveBreakpointParams(this.protocolId), removeCallback, guard.asSyncCallback());
    }

    private RelayOk recreateBreakpointAsync(final JavascriptVm.BreakpointCallback flushCallback, RelaySyncCallback relay) {
        RelayOk relayOk;
        if (this.enabled) {
            SetBreakpointCallback setCommandCallback = new SetBreakpointCallback(){

                @Override
                public void onSuccess(String protocolId, Collection<ActualLocation> actualLocations) {
                    WipBreakpointImpl.this.setRemoteData(protocolId, actualLocations);
                    if (flushCallback != null) {
                        flushCallback.success((Breakpoint)WipBreakpointImpl.this);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                    if (flushCallback != null) {
                        flushCallback.failure(exception.getMessage());
                    }
                }
            };
            RelaySyncCallback.Guard guard = relay.newGuard();
            if (this.condition == null) {
                this.condition = "";
            }
            return WipBreakpointImpl.sendSetBreakpointRequest(this.target, this.lineNumber, this.columnNumber, this.condition, setCommandCallback, guard.asSyncCallback(), this.breakpointManager.getCommandProcessor());
        }
        try {
            if (flushCallback != null) {
                flushCallback.success((Breakpoint)this);
            }
        }
        finally {
            relayOk = relay.finish();
        }
        return relayOk;
    }

    static RelayOk sendSetBreakpointRequest(Breakpoint.Target target, final int lineNumber, int columnNumber, final String condition, final SetBreakpointCallback callback, final SyncCallback syncCallback, final WipCommandProcessor commandProcessor) {
        final Long columnNumberParam = columnNumber == -1 ? null : Long.valueOf(columnNumber);
        return (RelayOk)target.accept((Breakpoint.Target.Visitor)new BreakpointTypeExtension.ScriptRegExpSupport.Visitor<RelayOk>(){

            public RelayOk visitScriptName(String scriptName) {
                return this.sendRequest(scriptName, RequestHandler.FOR_URL);
            }

            public RelayOk visitRegExp(String regExp) {
                return this.sendRequest(regExp, RequestHandler.FOR_REGEXP);
            }

            public RelayOk visitScriptId(Object scriptId) {
                String scriptIdString = WipScriptManager.convertAlienSourceId(scriptId);
                return this.sendRequest(scriptIdString, RequestHandler.FOR_ID);
            }

            public RelayOk visitUnknown(Breakpoint.Target target) {
                throw new IllegalArgumentException();
            }

            private <T, DATA, PARAMS extends WipParamsWithResponse<DATA>> RelayOk sendRequest(T parameter, final RequestHandler<T, DATA, PARAMS> handler) {
                PARAMS requestParams = handler.createRequestParams(parameter, lineNumber, columnNumberParam, condition);
                GenericCallback wrappedCallback = callback == null ? null : new GenericCallback<DATA>(){

                    public void success(DATA data) {
                        String breakpointId = handler.getBreakpointId(data);
                        Collection<LocationValue> locationValues = handler.getActualLocations(data);
                        ArrayList<ActualLocation> locationList = new ArrayList<ActualLocation>(locationValues.size());
                        for (LocationValue value : locationValues) {
                            locationList.add(WipBreakpointImpl.locationFromProtocol(value));
                        }
                        callback.onSuccess(breakpointId, locationList);
                    }

                    public void failure(Exception exception) {
                        callback.onFailure(exception);
                    }
                };
                return commandProcessor.send(requestParams, wrappedCallback, syncCallback);
            }
        });
    }

    private static ActualLocation locationFromProtocol(LocationValue locationValue) {
        return new ActualLocation(locationValue.scriptId(), locationValue.lineNumber(), locationValue.columnNumber());
    }

    private static <T> boolean eq(T left, T right) {
        return left == right || left != null && left.equals(right);
    }

    static class ActualLocation {
        private final String sourceId;
        private final long lineNumber;
        private final Long columnNumber;

        ActualLocation(String sourceId, long lineNumber, Long columnNumber) {
            this.sourceId = sourceId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public boolean equals(Object obj) {
            ActualLocation other = (ActualLocation)obj;
            return this.sourceId.equals(other.sourceId) && this.lineNumber == other.lineNumber && WipBreakpointImpl.eq(this.columnNumber, other.columnNumber);
        }

        public int hashCode() {
            int column = this.columnNumber == null ? 0 : this.columnNumber.intValue();
            return this.sourceId.hashCode() + 31 * (int)this.lineNumber + column;
        }

        public String toString() {
            return "<sourceId=" + this.sourceId + ", line=" + this.lineNumber + ", column=" + this.columnNumber + ">";
        }
    }

    private static abstract class RequestHandler<T, DATA, PARAMS extends WipParamsWithResponse<DATA>> {
        static final ForUrlOrRegExp FOR_URL = new ForUrlOrRegExp(){

            @Override
            SetBreakpointByUrlParams createRequestParams(String url, long lineNumber, Long columnNumber, String condition) {
                return new SetBreakpointByUrlParams(lineNumber, url, null, columnNumber, condition);
            }
        };
        static final ForUrlOrRegExp FOR_REGEXP = new ForUrlOrRegExp(){

            @Override
            SetBreakpointByUrlParams createRequestParams(String url, long lineNumber, Long columnNumber, String condition) {
                return new SetBreakpointByUrlParams(lineNumber, null, url, columnNumber, condition);
            }
        };
        static final RequestHandler<String, SetBreakpointData, SetBreakpointParams> FOR_ID = new RequestHandler<String, SetBreakpointData, SetBreakpointParams>(){

            @Override
            SetBreakpointParams createRequestParams(String sourceId, long lineNumber, Long columnNumber, String condition) {
                LocationParam locationParam = new LocationParam(sourceId, lineNumber, columnNumber);
                return new SetBreakpointParams(locationParam, condition);
            }

            @Override
            String getBreakpointId(SetBreakpointData data) {
                return data.breakpointId();
            }

            @Override
            Collection<LocationValue> getActualLocations(SetBreakpointData data) {
                return Collections.singletonList(data.actualLocation());
            }
        };

        private RequestHandler() {
        }

        abstract PARAMS createRequestParams(T var1, long var2, Long var4, String var5);

        abstract String getBreakpointId(DATA var1);

        abstract Collection<LocationValue> getActualLocations(DATA var1);

        static abstract class ForUrlOrRegExp
        extends RequestHandler<String, SetBreakpointByUrlData, SetBreakpointByUrlParams> {
            ForUrlOrRegExp() {
            }

            @Override
            String getBreakpointId(SetBreakpointByUrlData data) {
                return data.breakpointId();
            }

            @Override
            Collection<LocationValue> getActualLocations(SetBreakpointByUrlData data) {
                return data.locations();
            }
        }
    }

    static interface SetBreakpointCallback {
        public void onSuccess(String var1, Collection<ActualLocation> var2);

        public void onFailure(Exception var1);
    }
}

