/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.text.correction;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.html.ui.internal.editor.HTMLEditorPluginImageHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class RemoveAttributesProposal
implements ICompletionProposal {
    private IStructuredDocumentRegion fTag;
    private String fDisplayString;

    public RemoveAttributesProposal(IStructuredDocumentRegion tag, String displayString) {
        this.fTag = tag;
        this.fDisplayString = displayString;
    }

    boolean isEndType(String regionType) {
        return regionType.equals("XML_TAG_CLOSE") || regionType.equals("XML_EMPTY_TAG_CLOSE");
    }

    public void apply(IDocument document) {
        ITextRegionList regions = this.fTag.getRegions();
        if (this.fTag.getNumberOfRegions() > 2) {
            int removalStart = this.fTag.getTextEndOffset(regions.get(1));
            int removalEnd = this.fTag.getStartOffset(this.fTag.getLastRegion());
            try {
                document.replace(removalStart, removalEnd - removalStart, "");
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public Image getImage() {
        return HTMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fTag.getEndOffset(this.fTag.getRegions().get(1)), 0);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoveAttributesProposal) {
            RemoveAttributesProposal p = (RemoveAttributesProposal)obj;
            return this.fTag.equals(p.fTag);
        }
        return false;
    }
}

