/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.ui.dialogs.IStyleConstants;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class BlockPreferencePage
extends PreferencePage {
    private CSSPropertyContext _style;
    private StyleCombo _wordSpacingNumberCombo;
    private StyleCombo _wordSpacingUnitCombo;
    private StyleCombo _letterSpacingNumberCombo;
    private StyleCombo _letterSpacingUnitCombo;
    private StyleCombo _verticalAlignNumberCombo;
    private StyleCombo _verticalAlignUnitCombo;
    private StyleCombo _textAlignCombo;
    private StyleCombo _textIndentUnitCombo;
    private StyleCombo _whiteSpaceCombo;
    private StyleCombo _displayCombo;
    private Text _textIndentText;

    public BlockPreferencePage(IDOMElement element, CSSPropertyContext style) {
        this._style = style;
        this.setTitle(DialogsMessages.getString("BlockPreferencePage.Title"));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData(1808);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)data);
        Label wordSpacingLabel = new Label(top, 0);
        wordSpacingLabel.setText(DialogsMessages.getString("BlockPreferencePage.WordSpacing"));
        data = new GridData(128);
        wordSpacingLabel.setLayoutData((Object)data);
        this._wordSpacingNumberCombo = new StyleCombo(top, 0);
        this._wordSpacingNumberCombo.setItems(IStyleConstants.NORMAL);
        data = new GridData(768);
        this._wordSpacingNumberCombo.setLayoutData(data);
        this._wordSpacingNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockPreferencePage.this._wordSpacingUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(BlockPreferencePage.this._wordSpacingNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    BlockPreferencePage.this._wordSpacingUnitCombo.setEnabled(false);
                }
                Object spacing = BlockPreferencePage.this._wordSpacingNumberCombo.getText();
                if (BlockPreferencePage.this._wordSpacingUnitCombo.isEnabled()) {
                    spacing = (String)spacing + BlockPreferencePage.this._wordSpacingUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setWordSpacing((String)spacing);
            }
        });
        this._wordSpacingUnitCombo = new StyleCombo(top, 8);
        this._wordSpacingUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(768);
        this._wordSpacingUnitCombo.setLayoutData(data);
        this._wordSpacingUnitCombo.select(0);
        this._wordSpacingUnitCombo.setEnabled(false);
        this._wordSpacingUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object spacing = BlockPreferencePage.this._wordSpacingNumberCombo.getText();
                if (BlockPreferencePage.this._wordSpacingUnitCombo.isEnabled()) {
                    spacing = (String)spacing + BlockPreferencePage.this._wordSpacingUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setWordSpacing((String)spacing);
            }
        });
        Label letterSpacingLabel = new Label(top, 0);
        letterSpacingLabel.setText(DialogsMessages.getString("BlockPreferencePage.LetterSpacing"));
        data = new GridData(128);
        letterSpacingLabel.setLayoutData((Object)data);
        this._letterSpacingNumberCombo = new StyleCombo(top, 0);
        this._letterSpacingNumberCombo.setItems(IStyleConstants.NORMAL);
        data = new GridData(768);
        this._letterSpacingNumberCombo.setLayoutData(data);
        this._letterSpacingNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockPreferencePage.this._letterSpacingUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(BlockPreferencePage.this._letterSpacingNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    BlockPreferencePage.this._letterSpacingUnitCombo.setEnabled(false);
                }
                Object spacing = BlockPreferencePage.this._letterSpacingNumberCombo.getText();
                if (BlockPreferencePage.this._letterSpacingUnitCombo.isEnabled()) {
                    spacing = (String)spacing + BlockPreferencePage.this._letterSpacingUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setLetterSpacing((String)spacing);
            }
        });
        this._letterSpacingUnitCombo = new StyleCombo(top, 8);
        this._letterSpacingUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(768);
        this._letterSpacingUnitCombo.setLayoutData(data);
        this._letterSpacingUnitCombo.select(0);
        this._letterSpacingUnitCombo.setEnabled(false);
        this._letterSpacingUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object spacing = BlockPreferencePage.this._letterSpacingNumberCombo.getText();
                if (BlockPreferencePage.this._letterSpacingUnitCombo.isEnabled()) {
                    spacing = (String)spacing + BlockPreferencePage.this._letterSpacingUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setLetterSpacing((String)spacing);
            }
        });
        Label verticalAlignLabel = new Label(top, 0);
        verticalAlignLabel.setText(DialogsMessages.getString("BlockPreferencePage.VerticalAlign"));
        data = new GridData(128);
        verticalAlignLabel.setLayoutData((Object)data);
        this._verticalAlignNumberCombo = new StyleCombo(top, 0);
        this._verticalAlignNumberCombo.setItems(IStyleConstants.VERTICAL_ALIGN);
        data = new GridData(768);
        this._verticalAlignNumberCombo.setLayoutData(data);
        this._verticalAlignNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockPreferencePage.this._verticalAlignUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(BlockPreferencePage.this._verticalAlignNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    BlockPreferencePage.this._verticalAlignUnitCombo.setEnabled(false);
                }
                Object align = BlockPreferencePage.this._verticalAlignNumberCombo.getText();
                if (BlockPreferencePage.this._verticalAlignUnitCombo.isEnabled()) {
                    align = (String)align + BlockPreferencePage.this._verticalAlignUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setVerticalAlign((String)align);
            }
        });
        this._verticalAlignUnitCombo = new StyleCombo(top, 8);
        this._verticalAlignUnitCombo.setItems(IStyleConstants.PERCENT);
        data = new GridData(768);
        this._verticalAlignUnitCombo.setLayoutData(data);
        this._verticalAlignUnitCombo.select(0);
        this._verticalAlignUnitCombo.setEnabled(false);
        this._verticalAlignUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object align = BlockPreferencePage.this._verticalAlignNumberCombo.getText();
                if (BlockPreferencePage.this._verticalAlignUnitCombo.isEnabled()) {
                    align = (String)align + BlockPreferencePage.this._verticalAlignUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setVerticalAlign((String)align);
            }
        });
        Label textAlignLabel = new Label(top, 0);
        textAlignLabel.setText(DialogsMessages.getString("BlockPreferencePage.TextAlign"));
        data = new GridData(128);
        textAlignLabel.setLayoutData((Object)data);
        this._textAlignCombo = new StyleCombo(top, 0);
        this._textAlignCombo.setItems(IStyleConstants.TEXT_ALIGN);
        data = new GridData(768);
        this._textAlignCombo.setLayoutData(data);
        this._textAlignCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String align = BlockPreferencePage.this._textAlignCombo.getText();
                BlockPreferencePage.this._style.setTextAlign(align);
            }
        });
        new Label(top, 0);
        Label textIndentLabel = new Label(top, 0);
        textIndentLabel.setText(DialogsMessages.getString("BlockPreferencePage.TextIndent"));
        data = new GridData(128);
        textIndentLabel.setLayoutData((Object)data);
        this._textIndentText = new Text(top, 2048);
        data = new GridData(768);
        this._textIndentText.setLayoutData((Object)data);
        this._textIndentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockPreferencePage.this._textIndentUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(BlockPreferencePage.this._textIndentText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    BlockPreferencePage.this._textIndentUnitCombo.setEnabled(false);
                }
                Object indent = BlockPreferencePage.this._textIndentText.getText();
                if (BlockPreferencePage.this._textIndentUnitCombo.isEnabled()) {
                    indent = (String)indent + BlockPreferencePage.this._textIndentUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setTextIndent((String)indent);
            }
        });
        this._textIndentUnitCombo = new StyleCombo(top, 8);
        this._textIndentUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(768);
        this._textIndentUnitCombo.setLayoutData(data);
        this._textIndentUnitCombo.select(0);
        this._textIndentUnitCombo.setEnabled(false);
        this._textIndentUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object indent = BlockPreferencePage.this._textIndentText.getText();
                if (BlockPreferencePage.this._textIndentUnitCombo.isEnabled()) {
                    indent = (String)indent + BlockPreferencePage.this._textIndentUnitCombo.getText();
                }
                BlockPreferencePage.this._style.setTextIndent((String)indent);
            }
        });
        Label whiteSpaceLabel = new Label(top, 0);
        whiteSpaceLabel.setText(DialogsMessages.getString("BlockPreferencePage.WhiteSpace"));
        data = new GridData(128);
        whiteSpaceLabel.setLayoutData((Object)data);
        this._whiteSpaceCombo = new StyleCombo(top, 0);
        this._whiteSpaceCombo.setItems(IStyleConstants.WHITE_SPACE);
        data = new GridData(768);
        this._whiteSpaceCombo.setLayoutData(data);
        this._whiteSpaceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String space = BlockPreferencePage.this._whiteSpaceCombo.getText();
                BlockPreferencePage.this._style.setWhiteSpace(space);
            }
        });
        new Label(top, 0);
        Label displayLabel = new Label(top, 0);
        displayLabel.setText(DialogsMessages.getString("BlockPreferencePage.Display"));
        data = new GridData(128);
        displayLabel.setLayoutData((Object)data);
        this._displayCombo = new StyleCombo(top, 0);
        this._displayCombo.setItems(IStyleConstants.DISPLAY);
        data = new GridData(768);
        this._displayCombo.setLayoutData(data);
        this._displayCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String display = BlockPreferencePage.this._displayCombo.getText();
                BlockPreferencePage.this._style.setDisplay(display);
            }
        });
        this.initializeControls();
        return top;
    }

    private void initializeControls() {
        String display;
        String space;
        String indent;
        int index;
        String align;
        int index2;
        String spacing = this._style.getWordSpacing();
        if (!this.isEmptyString(spacing)) {
            index2 = this._wordSpacingNumberCombo.indexOf(spacing);
            if (index2 != -1) {
                this._wordSpacingNumberCombo.select(index2);
            } else {
                this._wordSpacingNumberCombo.setText(spacing);
            }
        }
        if (!this.isEmptyString(spacing = this._style.getLetterSpacing())) {
            index2 = this._letterSpacingNumberCombo.indexOf(spacing);
            if (index2 != -1) {
                this._letterSpacingNumberCombo.select(index2);
            } else {
                this._letterSpacingNumberCombo.setText(spacing);
            }
        }
        if (!this.isEmptyString(align = this._style.getVerticalAlign())) {
            index = this._verticalAlignNumberCombo.indexOf(align);
            if (index != -1) {
                this._verticalAlignNumberCombo.select(index);
            } else {
                this._verticalAlignNumberCombo.setText(align);
            }
        }
        if (!this.isEmptyString(align = this._style.getTextAlign())) {
            index = this._textAlignCombo.indexOf(align);
            if (index != -1) {
                this._textAlignCombo.select(index);
            } else {
                this._textAlignCombo.setText(align);
            }
        }
        if (!this.isEmptyString(indent = this._style.getTextIndent())) {
            this._textIndentText.setText(indent);
        }
        if (!this.isEmptyString(space = this._style.getWhiteSpace())) {
            int index3 = this._whiteSpaceCombo.indexOf(space);
            if (index3 != -1) {
                this._whiteSpaceCombo.select(index3);
            } else {
                this._whiteSpaceCombo.setText(space);
            }
        }
        if (!this.isEmptyString(display = this._style.getDisplay())) {
            int index4 = this._displayCombo.indexOf(display);
            if (index4 != -1) {
                this._displayCombo.select(index4);
            } else {
                this._displayCombo.setText(display);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getApplyButton().setVisible(false);
        this.getDefaultsButton().setVisible(false);
    }

    private boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

