/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details.orm;

import java.util.ArrayList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.details.orm.JptJpaUiDetailsOrmMessages;
import org.eclipse.jpt.jpa.ui.internal.details.orm.AddGeneratorStateObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddGeneratorDialog
extends ValidatingDialog<AddGeneratorStateObject> {
    public static final String SEQUENCE_GENERATOR = "sequenceGenerator";
    public static final String TABLE_GENERATOR = "tableGenerator";
    private PersistenceUnit pUnit;

    public AddGeneratorDialog(Shell parent, ResourceManager resourceManager, PersistenceUnit pUnit) {
        super(parent, resourceManager, JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_TITLE);
        this.pUnit = pUnit;
    }

    protected AddGeneratorStateObject buildStateObject() {
        return new AddGeneratorStateObject(this.pUnit);
    }

    protected String getDescriptionTitle() {
        return JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_DESCRIPTION_TITLE;
    }

    protected String getDescription() {
        return JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_DESCRIPTION;
    }

    protected DialogPane<AddGeneratorStateObject> buildLayout(Composite container) {
        return new GeneratorDialogPane((PropertyValueModel<AddGeneratorStateObject>)this.getSubjectHolder(), container, this.resourceManager);
    }

    public void create() {
        super.create();
        GeneratorDialogPane pane = (GeneratorDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return ((AddGeneratorStateObject)this.getSubject()).getName();
    }

    public String getGeneratorType() {
        return ((AddGeneratorStateObject)this.getSubject()).getGeneratorType();
    }

    static class GeneratorDialogPane
    extends DialogPane<AddGeneratorStateObject> {
        private Text nameText;

        GeneratorDialogPane(PropertyValueModel<AddGeneratorStateObject> subjectModel, Composite parentComposite, ResourceManager resourceManager) {
            super(subjectModel, parentComposite, resourceManager);
        }

        protected Composite addComposite(Composite container) {
            return this.addSubPane(container, 2, 0, 0, 0, 0);
        }

        protected void initializeLayout(Composite container) {
            this.addLabel(container, JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_NAME);
            this.nameText = this.addText(container, this.buildNameHolder());
            this.addLabel(container, JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_GENERATOR_TYPE);
            this.addCombo(container, this.buildGeneratorTypeListHolder(), this.buildGeneratorTypeHolder(), this.buildStringConverter(), null);
        }

        protected ListValueModel<String> buildGeneratorTypeListHolder() {
            ArrayList<String> generatorTypes = new ArrayList<String>();
            generatorTypes.add(AddGeneratorDialog.TABLE_GENERATOR);
            generatorTypes.add(AddGeneratorDialog.SEQUENCE_GENERATOR);
            return new StaticListValueModel(generatorTypes);
        }

        private Transformer<String, String> buildStringConverter() {
            return new GeneratorTypeLabelTransformer();
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<AddGeneratorStateObject, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

                protected String buildValue_() {
                    return ((AddGeneratorStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((AddGeneratorStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildGeneratorTypeHolder() {
            return new PropertyAspectAdapter<AddGeneratorStateObject, String>(this.getSubjectHolder(), new String[]{"generatorTypeProperty"}){

                protected String buildValue_() {
                    return ((AddGeneratorStateObject)((Object)this.subject)).getGeneratorType();
                }

                protected void setValue_(String value) {
                    ((AddGeneratorStateObject)((Object)this.subject)).setGeneratorType(value);
                }
            };
        }

        void selectAll() {
            this.nameText.selectAll();
        }

        static class GeneratorTypeLabelTransformer
        extends TransformerAdapter<String, String> {
            GeneratorTypeLabelTransformer() {
            }

            public String transform(String value) {
                if (value == AddGeneratorDialog.TABLE_GENERATOR) {
                    return JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_TABLE_GENERATOR;
                }
                if (value == AddGeneratorDialog.SEQUENCE_GENERATOR) {
                    return JptJpaUiDetailsOrmMessages.ADD_GENERATOR_DIALOG_SEQUENCE_GENERATOR;
                }
                return value;
            }
        }
    }
}

