/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.xml;

import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.DocumentReader;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILElementWithAbstract;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.ExtensionReader;
import org.apache.wsil.extension.ExtensionRegistry;
import org.apache.wsil.extension.UnknownExtensionElement;
import org.apache.wsil.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class XMLReader
implements DocumentReader {
    protected Reader reader = null;
    protected WSILDocument wsilDocument = null;
    protected ExtensionRegistry extRegistry = null;

    protected Abstract parseAbstract(Element element, WSILElementWithAbstract wSILElementWithAbstract) throws WSILException {
        Abstract abstract_ = this.wsilDocument.createAbstract();
        String string = XMLUtil.getAttributeValue(element, "xml:lang");
        if (string != null) {
            abstract_.setLang(string);
        }
        abstract_.setText(XMLUtil.getText(element));
        return abstract_;
    }

    protected Description parseDescription(Element element, Service service) throws WSILException {
        Description description = this.wsilDocument.createDescription();
        description.setLocation(XMLUtil.getAttributeValue(element, "location"));
        description.setReferencedNamespace(XMLUtil.getAttributeValue(element, "referencedNamespace"));
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (Abstract.QNAME.equals(element2)) {
                description.addAbstract(this.parseAbstract(element2, description));
            } else {
                description.setExtensionElement(this.parseExtensionElement(element2, description));
            }
            element2 = XMLUtil.getNextSibling(element2);
        }
        return description;
    }

    public void parseDocument(WSILDocument wSILDocument, Reader reader) throws WSILException {
        this.reader = reader;
        this.wsilDocument = wSILDocument;
        this.extRegistry = wSILDocument.getExtensionRegistry();
        if (this.extRegistry == null) {
            throw new WSILException("WSIL document does not have a defined extension registry.");
        }
        this.parseInspection(this.parseXML(reader).getDocumentElement());
    }

    protected ExtensionElement parseExtensionElement(Element element, WSILElement wSILElement) throws WSILException {
        ExtensionElement extensionElement = null;
        ExtensionReader extensionReader = null;
        QName qName = new QName(element);
        extensionReader = this.extRegistry.getReader(qName.getNamespaceURI());
        extensionElement = extensionReader == null ? new UnknownExtensionElement(qName, element) : extensionReader.parseElement(element, wSILElement);
        return extensionElement;
    }

    protected void parseInspection(Element element) throws WSILException {
        Inspection inspection = this.wsilDocument.getInspection();
        inspection.setTargetNamespace(XMLUtil.getAttributeValue(element, "targetNamespace"));
        this.saveNS(element, inspection);
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (Abstract.QNAME.equals(element2)) {
                inspection.addAbstract(this.parseAbstract(element2, inspection));
            } else if (Link.QNAME.equals(element2)) {
                inspection.addLink(this.parseLink(element2, inspection));
            } else if (Service.QNAME.equals(element2)) {
                inspection.addService(this.parseService(element2, inspection));
            } else {
                throw new WSILException("WSIL document contains undefined element: " + element2.getTagName() + ".");
            }
            element2 = XMLUtil.getNextSibling(element2);
        }
    }

    protected Link parseLink(Element element, Inspection inspection) throws WSILException {
        Link link = this.wsilDocument.createLink();
        link.setLocation(XMLUtil.getAttributeValue(element, "location"));
        link.setReferencedNamespace(XMLUtil.getAttributeValue(element, "referencedNamespace"));
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (Abstract.QNAME.equals(element2)) {
                link.addAbstract(this.parseAbstract(element2, link));
            } else {
                link.setExtensionElement(this.parseExtensionElement(element2, link));
            }
            element2 = XMLUtil.getNextSibling(element2);
        }
        return link;
    }

    protected Service parseService(Element element, Inspection inspection) throws WSILException {
        Service service = this.wsilDocument.createService();
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (Abstract.QNAME.equals(element2)) {
                service.addAbstract(this.parseAbstract(element2, service));
            } else if (ServiceName.QNAME.equals(element2)) {
                service.addServiceName(this.parseServiceName(element2, service));
            } else if (Description.QNAME.equals(element2)) {
                service.addDescription(this.parseDescription(element2, service));
            } else {
                throw new WSILException("WSIL document contains undefined element: " + element2.getTagName() + ".");
            }
            element2 = XMLUtil.getNextSibling(element2);
        }
        return service;
    }

    protected ServiceName parseServiceName(Element element, Service service) throws WSILException {
        ServiceName serviceName = this.wsilDocument.createServiceName();
        String string = XMLUtil.getAttributeValue(element, "xml:lang");
        if (string != null) {
            serviceName.setLang(string);
        }
        serviceName.setText(XMLUtil.getText(element));
        return serviceName;
    }

    protected Document parseXML(Reader reader) throws WSILException {
        Document document = null;
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WSILException("Could not parse WSIL document.", exception);
        }
        return document;
    }

    protected void saveNS(Element element, Inspection inspection) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getValue();
            String string2 = attr.getNamespaceURI();
            if (string2 == null || !string2.equals("http://www.w3.org/2000/xmlns/")) continue;
            String string3 = attr.getLocalName();
            if (string3 != null && string3.equals("xmlns")) {
                inspection.addNamespace(null, string);
                continue;
            }
            inspection.addNamespace(string3, string);
        }
    }
}

