/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;

public class RangeUtil {
    public static boolean intersect(DesignRange range, EditPart part) {
        if (range == null || !range.isValid()) {
            return false;
        }
        range = RangeUtil.normalize(range);
        if (part instanceof DocumentEditPart) {
            return true;
        }
        EditPart parent = part.getParent();
        int index = parent.getChildren().indexOf(part);
        DesignPosition left = new DesignPosition(parent, index);
        DesignPosition right = new DesignPosition(parent, index + 1);
        int compare = RangeUtil.compareDesignPosition(left, range.getEndPosition());
        if (compare == 1 || compare == 0 || compare == Integer.MIN_VALUE) {
            return false;
        }
        compare = RangeUtil.compareDesignPosition(right, range.getStartPosition());
        return compare != -1 && compare != 0 && compare != Integer.MIN_VALUE;
    }

    public static DesignRange normalize(DesignRange range) {
        if (range == null || !range.isValid()) {
            return range;
        }
        int result = RangeUtil.compareDesignPosition(range.getStartPosition(), range.getEndPosition());
        if (result == 1) {
            return new DesignRange(range.getEndPosition(), range.getStartPosition());
        }
        return range;
    }

    private static int compareDesignPosition(DesignPosition p1, DesignPosition p2) {
        if (!p1.isValid() || !p2.isValid()) {
            return Integer.MIN_VALUE;
        }
        if (p1.equals(p2)) {
            return 0;
        }
        int offset1 = p1.getOffset();
        int offset2 = p2.getOffset();
        List a1 = RangeUtil.getAncesters(p1.getContainerPart());
        List a2 = RangeUtil.getAncesters(p2.getContainerPart());
        if (a1 == null || a2 == null) {
            return Integer.MIN_VALUE;
        }
        if (a1.get(0) != a2.get(0)) {
            return Integer.MIN_VALUE;
        }
        int i = 1;
        while (true) {
            EditPart p2a;
            EditPart p1a;
            if ((p1a = (EditPart)a1.get(i)) == (p2a = (EditPart)a2.get(i))) {
                if (p1a == null) {
                    return offset1 < offset2 ? -1 : (offset1 == offset2 ? 0 : 1);
                }
            } else {
                if (p1a != null) {
                    offset1 = p1a.getParent().getChildren().indexOf(p1a);
                }
                if (p2a != null) {
                    offset2 = p2a.getParent().getChildren().indexOf(p2a);
                }
                if (p1a == null && p2a == null || p1a != null && p2a != null) {
                    return offset1 < offset2 ? -1 : (offset1 == offset2 ? 0 : 1);
                }
                if (p1a == null) {
                    return offset1 <= offset2 ? -1 : 1;
                }
                return offset1 >= offset2 ? 1 : -1;
            }
            ++i;
        }
    }

    private static List getAncesters(EditPart part) {
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        while (part != null) {
            list.add(part);
            if (part instanceof DocumentEditPart) break;
            part = part.getParent();
        }
        if (part == null) {
            return null;
        }
        Collections.reverse(list);
        list.add(null);
        return list;
    }

    private static EditPart findCommonAncester(EditPart part1, EditPart part2) {
        if (part1 == part2) {
            return part1;
        }
        List list1 = RangeUtil.getAncesters(part1);
        if (list1 == null) {
            return null;
        }
        List list2 = RangeUtil.getAncesters(part2);
        if (list2 == null) {
            return null;
        }
        if (list1.get(0) != list2.get(0)) {
            return null;
        }
        EditPart common = (EditPart)list1.get(0);
        int i = 1;
        while (true) {
            EditPart p1 = (EditPart)list1.get(i);
            EditPart p2 = (EditPart)list2.get(i);
            if (p1 == null || p2 == null) {
                return common;
            }
            if (p1 != p2) {
                return common;
            }
            common = p1;
            ++i;
        }
    }

    public static EditPart findCommonAncestor(DesignRange range) {
        if (!range.isValid()) {
            return null;
        }
        DesignPosition startPosition = range.getStartPosition();
        DesignPosition endPosition = range.getEndPosition();
        return RangeUtil.findCommonAncester(startPosition.getContainerPart(), endPosition.getContainerPart());
    }
}

