/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import java.util.Enumeration;
import org.eclipse.wst.ws.internal.datamodel.ElementAdapter;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.UDDIMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.BusinessNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.OpenRegistryTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.PublishedItemsNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryParentNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceInterfaceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;

public class UDDIMainNode
extends UDDINavigatorNode {
    public UDDIMainNode(TreeElement element, NodeManager nodeManager) {
        super(element, nodeManager, 1, "images/root_main.gif");
        element.addListener((ElementListener)new ElementAdapter(){

            public void relAdded(RelAddEvent event) {
                String rel = event.getOutBoundRelName();
                if (rel.equals("registries")) {
                    RegistryElement registryElement = (RegistryElement)event.getParentElement();
                    UDDIMainElement uddiMainElement = (UDDIMainElement)UDDIMainNode.this.element_;
                    uddiMainElement.addRegistryName(registryElement.getName());
                    UDDIMainNode.this.createChildNode(registryElement);
                }
            }

            public void relRemoved(RelRemoveEvent event) {
                RegistryElement childElement = null;
                if (event.getInBoundRelName().equals("registries")) {
                    childElement = (RegistryElement)event.getInboundElement();
                } else if (event.getOutBoundRelName().equals("registries")) {
                    childElement = (RegistryElement)event.getOutBoundElement();
                }
                if (childElement != null) {
                    UDDIMainElement uddiMainElement = (UDDIMainElement)UDDIMainNode.this.element_;
                    uddiMainElement.removeRegistryName(childElement.getName());
                    UDDIMainNode.this.removeChildNode(childElement);
                }
            }
        });
    }

    private final void createChildNode(TreeElement element) {
        RegistryElement regElement = (RegistryElement)element;
        Enumeration userDefinedCategories = regElement.getUserDefinedCategories();
        String imagePath = userDefinedCategories != null && userDefinedCategories.hasMoreElements() ? "uddi/images/regstrycat_obj.gif" : "uddi/images/registry.gif";
        RegistryNode regNode = new RegistryNode(element, this.nodeManager_, this.nodeDepth_ + 1, imagePath);
        this.addChild(regNode);
    }

    @Override
    protected final void initTools() {
        Controller controller = this.nodeManager_.getController();
        UDDIPerspective uddiPerspective = controller.getUDDIPerspective();
        new OpenRegistryTool(this.toolManager_, uddiPerspective.getMessage("ALT_OPEN_REGISTRY"));
    }

    public final RegistryNode getRegistryNode(Node currentNode) {
        RegistryNode regNode = null;
        if (currentNode instanceof RegistryNode) {
            regNode = (RegistryNode)currentNode;
        } else if (currentNode instanceof QueryNode) {
            regNode = (RegistryNode)currentNode.getParent().getParent();
        } else if (currentNode instanceof QueryParentNode || currentNode instanceof PublishedItemsNode) {
            regNode = (RegistryNode)currentNode.getParent();
        } else if (currentNode instanceof BusinessNode || currentNode instanceof ServiceNode || currentNode instanceof ServiceInterfaceNode) {
            Node parentNode = currentNode.getParent();
            regNode = parentNode instanceof QueryNode ? (RegistryNode)parentNode.getParent().getParent() : (RegistryNode)parentNode.getParent();
        }
        return regNode;
    }
}

