/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.publishers.DefaultModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.EarModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.ModulePackager;
import org.eclipse.jst.server.generic.core.internal.publishers.WarModuleAssembler;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.server.core.util.PublishHelper;

public abstract class AbstractModuleAssembler {
    protected ServerRuntime fServerdefinition;
    protected IModule fModule;
    protected GenericServer fServer;
    protected IPath fAssembleRoot;
    protected PublishHelper publishHelper;

    protected AbstractModuleAssembler(IModule module, GenericServer server, IPath assembleRoot) {
        this.fModule = module;
        this.fServerdefinition = server.getServerDefinition();
        this.fServer = server;
        this.fAssembleRoot = assembleRoot;
        this.publishHelper = new PublishHelper(CorePlugin.getDefault().getStateLocation().append("tmp").toFile());
    }

    public abstract IPath assemble(IProgressMonitor var1) throws CoreException;

    protected void packModule(IModule module, String deploymentUnitName, IPath destination) throws CoreException {
        String dest = destination.append(deploymentUnitName).toString();
        ModulePackager packager = null;
        try {
            try {
                packager = new ModulePackager(dest, false);
                ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                int i = 0;
                while (i < resources.length) {
                    this.doPackModule(resources[i], packager);
                    ++i;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            try {
                packager.finished();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            packager.finished();
        }
        catch (IOException iOException) {}
    }

    private void doPackModule(IModuleResource resource, ModulePackager packager) throws CoreException, IOException {
        if (resource instanceof IModuleFolder) {
            IModuleFolder mFolder = (IModuleFolder)resource;
            IModuleResource[] resources = mFolder.members();
            packager.writeFolder(resource.getModuleRelativePath().append(resource.getName()).toPortableString());
            int i = 0;
            while (resources != null && i < resources.length) {
                this.doPackModule(resources[i], packager);
                ++i;
            }
        } else {
            String destination = resource.getModuleRelativePath().append(resource.getName()).toPortableString();
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file != null) {
                packager.write(file, destination);
            } else {
                File file2 = (File)resource.getAdapter(File.class);
                packager.write(file2, destination);
            }
        }
    }

    protected IPath copyModule(IModule module, IProgressMonitor monitor) throws CoreException {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, monitor);
        IStatus[] status = this.publishHelper.publishSmart(pm.members(), this.fAssembleRoot, monitor);
        if (status != null && status.length > 0) {
            throw new CoreException(status[0]);
        }
        return this.fAssembleRoot;
    }

    public static class Factory {
        public static IPath getDefaultAssembleRoot(IModule module, GenericServer server) {
            ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, (IProgressMonitor)new NullProgressMonitor());
            GenericServerBehaviour genericServer = (GenericServerBehaviour)((Object)server.getServer().loadAdapter(ServerBehaviourDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
            if (genericServer == null) {
                CorePlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.jst.server.generic.core", "GenericServerBehavior was not loaded when determining assembly root. Falling back to state location"));
                return CorePlugin.getDefault().getStateLocation().append(pm.getId());
            }
            return genericServer.getTempDirectory().append(pm.getId());
        }

        public static AbstractModuleAssembler getModuleAssembler(IModule module, GenericServer server) {
            return Factory.getModuleAssembler(module, server, Factory.getDefaultAssembleRoot(module, server));
        }

        public static AbstractModuleAssembler getModuleAssembler(IModule module, GenericServer server, IPath assembleRoot) {
            if (Factory.isModuleType(module, "jst.web")) {
                return new WarModuleAssembler(module, server, assembleRoot);
            }
            if (Factory.isModuleType(module, "jst.ear")) {
                return new EarModuleAssembler(module, server, assembleRoot);
            }
            return new DefaultModuleAssembler(module, server, assembleRoot);
        }

        private static boolean isModuleType(IModule module, String moduleTypeId) {
            return module.getModuleType() != null && moduleTypeId.equals(module.getModuleType().getId());
        }
    }
}

