/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;

public abstract class LineBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null) {
            IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getDebugModelId());
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            ChromiumLineBreakpoint lineBreakpoint = new ChromiumLineBreakpoint(resource, lineNumber + 1, this.getDebugModelId());
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    protected abstract ITextEditor getEditor(IWorkbenchPart var1);

    protected abstract String getDebugModelId();

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public static class ForVirtualProject
    extends LineBreakpointAdapter {
        @Override
        protected ITextEditor getEditor(IWorkbenchPart part) {
            return ForVirtualProject.getEditorStatic(part);
        }

        public static ITextEditor getEditorStatic(IWorkbenchPart part) {
            ITextEditor editorPart;
            IResource resource;
            if (part instanceof ITextEditor && (resource = (IResource)(editorPart = (ITextEditor)part).getEditorInput().getAdapter(IResource.class)) != null && ChromiumDebugPluginUtil.SUPPORTED_EXTENSIONS.contains(resource.getFileExtension())) {
                return editorPart;
            }
            return null;
        }

        @Override
        protected String getDebugModelId() {
            return "org.eclipse.wst.jsdt.chromium.debug";
        }
    }
}

