/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.style;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.CompatibleHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class ReconcilerHighlighter {
    private static final String LINE_STYLE_PROVIDER_EXTENDED_ID = "linestyleprovider";
    private Map fTableOfProviders = null;
    private Map fExtendedProviders = null;
    private ITextViewer fTextViewer = null;
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/structuredPresentationReconciler"));
    private static final String TRACE_PREFIX = "StructuredPresentationReconciler: ";
    private long time0;
    private CompatibleHighlighter fCompatibleHighlighter = null;

    public void refreshDisplay() {
        if (_trace) {
            this.time0 = System.currentTimeMillis();
        }
        if (this.fTextViewer != null) {
            this.fTextViewer.invalidateTextPresentation();
        }
        if (_trace) {
            System.out.println("StructuredPresentationReconciler: ReconcilerHighlighter refreshDisplay took " + (System.currentTimeMillis() - this.time0) + "ms");
            System.out.flush();
        }
    }

    public void addProvider(String partitionType, LineStyleProvider provider) {
        this.getTableOfProviders().put(partitionType, provider);
    }

    public void removeProvider(String partitionType) {
        this.getTableOfProviders().remove(partitionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineStyleProvider getProvider(String partitionType) {
        LineStyleProvider result = (LineStyleProvider)this.getTableOfProviders().get(partitionType);
        if (result == null) {
            Map map = this.getExtendedProviders();
            synchronized (map) {
                if (!this.getExtendedProviders().containsKey(partitionType)) {
                    result = (LineStyleProvider)ExtendedConfigurationBuilder.getInstance().getConfiguration(LINE_STYLE_PROVIDER_EXTENDED_ID, partitionType);
                    this.getExtendedProviders().put(partitionType, result);
                    if (result != null && this.fTextViewer != null && this.fTextViewer.getDocument() instanceof IStructuredDocument) {
                        if (result instanceof AbstractLineStyleProvider) {
                            ((AbstractLineStyleProvider)((Object)result)).init((IStructuredDocument)this.fTextViewer.getDocument(), this);
                        } else {
                            Logger.log(201, "CompatibleHighlighter installing compatibility for " + result.getClass());
                            if (this.fCompatibleHighlighter == null) {
                                this.fCompatibleHighlighter = new CompatibleHighlighter();
                                this.fCompatibleHighlighter.install(this.fTextViewer);
                            }
                            result.init((IStructuredDocument)this.fTextViewer.getDocument(), this.fCompatibleHighlighter);
                        }
                    }
                } else {
                    result = (LineStyleProvider)this.getExtendedProviders().get(partitionType);
                }
            }
        }
        return result;
    }

    private Map getTableOfProviders() {
        if (this.fTableOfProviders == null) {
            this.fTableOfProviders = new HashMap();
        }
        return this.fTableOfProviders;
    }

    private Map getExtendedProviders() {
        if (this.fExtendedProviders == null) {
            this.fExtendedProviders = new HashMap(3);
        }
        return this.fExtendedProviders;
    }

    public void install(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        if (this.fCompatibleHighlighter != null) {
            this.fCompatibleHighlighter.uninstall();
            this.fCompatibleHighlighter.install(this.fTextViewer);
        }
        this.refreshDisplay();
    }

    public void uninstall() {
        for (LineStyleProvider provider : this.getTableOfProviders().values()) {
            if (provider == null) continue;
            provider.release();
        }
        for (LineStyleProvider provider : this.getExtendedProviders().values()) {
            if (provider == null) continue;
            provider.release();
        }
        this.getTableOfProviders().clear();
        this.getExtendedProviders().clear();
        this.fTableOfProviders = null;
        if (this.fCompatibleHighlighter != null) {
            this.fCompatibleHighlighter.uninstall();
        }
        this.fTextViewer = null;
    }
}

