/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.text.MessageFormat;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.ProxyInitParserMessages;

public class CharLiteral
extends Expression {
    protected boolean isComplete;
    public char value;
    public StringBuffer valueBuffer = new StringBuffer();
    protected boolean isEscaped = false;

    @Override
    public Object evaluate() throws Exception {
        if (this.valueBuffer.length() == 1) {
            return new Character(this.valueBuffer.charAt(0));
        }
        throw new EvaluationException(new IllegalArgumentException(MessageFormat.format(ProxyInitParserMessages.getString("CharTooComplicated_EXC_"), this.valueBuffer.toString())));
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public Class getTypeClass() {
        return Character.TYPE;
    }

    @Override
    protected String getTypeClassName() {
        return Character.TYPE.getName();
    }

    @Override
    public Expression push(char[] token, char delimiter) {
        if (this.isEscaped) {
            this.isEscaped = false;
            if (token.length != 0) {
                this.valueBuffer.append('\\');
            } else {
                if (delimiter == '\'' || delimiter == '\\') {
                    this.valueBuffer.append(delimiter);
                } else {
                    this.valueBuffer.append('\\');
                    this.valueBuffer.append(delimiter);
                }
                return this;
            }
        }
        this.valueBuffer.append(token);
        if (delimiter == '\'') {
            this.isComplete = true;
            return this;
        }
        if (delimiter == '\\') {
            this.isEscaped = true;
        } else {
            this.valueBuffer.append(delimiter);
        }
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Char('");
        if (this.valueBuffer != null) {
            buffer.append(this.valueBuffer.toString());
        }
        buffer.append(')');
        return buffer.toString();
    }
}

