/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectFileOrXMLCatalogIdPanel;

public class SelectFileOrXMLCatalogIdDialog
extends Dialog {
    protected int catalogEntryType;
    protected String[] extensions;
    protected IFile file;
    protected String id;
    protected Button okButton;
    protected SelectFileOrXMLCatalogIdPanel panel;

    public SelectFileOrXMLCatalogIdDialog(Shell parentShell, String[] extensions) {
        this(parentShell, extensions, 0);
    }

    public SelectFileOrXMLCatalogIdDialog(Shell parentShell, String[] extensions, int catalogEntryType) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.extensions = extensions;
        this.catalogEntryType = catalogEntryType;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.file = this.panel.getFile();
            this.id = this.panel.getXMLCatalogId();
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.panel = new SelectFileOrXMLCatalogIdPanel(dialogArea);
        this.panel.setCatalogEntryType(this.catalogEntryType);
        this.panel.setFilterExtensions(this.extensions);
        this.panel.setVisibleHelper(true);
        SelectFileOrXMLCatalogIdPanel.Listener listener = new SelectFileOrXMLCatalogIdPanel.Listener(){

            @Override
            public void completionStateChanged() {
                SelectFileOrXMLCatalogIdDialog.this.updateButtonState();
            }
        };
        this.panel.setListener(listener);
        return dialogArea;
    }

    public IFile getFile() {
        return this.file;
    }

    public String getId() {
        return this.id;
    }

    protected void updateButtonState() {
        this.okButton.setEnabled(this.panel.getFile() != null || this.panel.getXMLCatalogId() != null);
    }
}

