/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.editors;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.chromium.debug.ui.editors.EditorColors;

public class JsCodeScanner
extends BufferedRuleBasedScanner {
    private Token commentToken;
    private final TextAttribute commentAttribute = new TextAttribute(EditorColors.getColor(new RGB(63, 127, 95)), null, 0);
    private final TextAttribute jsDocAttribute = new TextAttribute(EditorColors.getColor(new RGB(127, 127, 159)), null, 0);

    public JsCodeScanner() {
        this.createRules();
    }

    public TextAttribute getCommentAttribute() {
        return this.commentAttribute;
    }

    public TextAttribute getJsDocAttribute() {
        return this.jsDocAttribute;
    }

    private void createRules() {
        Token keywordToken = new Token((Object)new TextAttribute(EditorColors.getColor(new RGB(127, 0, 85)), null, 1));
        this.commentToken = new Token((Object)this.commentAttribute);
        Token jsDocToken = new Token((Object)this.jsDocAttribute);
        Token stringToken = new Token((Object)new TextAttribute(EditorColors.getColor(new RGB(42, 0, 255)), null, 0));
        RGB blackRgb = new RGB(0, 0, 0);
        Token numberToken = new Token((Object)new TextAttribute(EditorColors.getColor(blackRgb), null, 0));
        Token normalToken = new Token((Object)new TextAttribute(EditorColors.getColor(blackRgb), null, 0));
        this.setDefaultReturnToken((IToken)normalToken);
        this.setRules(new IRule[]{new EndOfLineRule("//", (IToken)this.commentToken), new KeywordRule(keywordToken), new MultiLineRule("/**", "*/", (IToken)jsDocToken, '\u0000', false), new MultiLineRule("/*", "*/", (IToken)this.commentToken, '\u0000', false), new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'), new SingleLineRule("/", "/", (IToken)stringToken, '\\'), new SingleLineRule("'", "'", (IToken)stringToken, '\\'), new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }), new WordRule((IWordDetector)new WordDetector(), (IToken)normalToken), new NumberRule((IToken)numberToken)});
    }

    private static class KeywordRule
    extends WordRule {
        private static final String[] KEYWORDS = new String[]{"break", "case", "catch", "const", "continue", "debugger", "default", "delete", "do", "else", "false", "finally", "for", "function", "if", "in", "instanceof", "new", "null", "return", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "__proto__", "prototype"};

        public KeywordRule(Token token) {
            super((IWordDetector)new WordDetector());
            String[] stringArray = KEYWORDS;
            int n = KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                this.addWord(word, (IToken)token);
                ++n2;
            }
        }
    }

    private static class WordDetector
    implements IWordDetector {
        private WordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    }
}

