/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.widgets;

import javax.jws.WebService;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.core.commands.Java2WSDefaultingCommand;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIMessages;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIPlugin;
import org.eclipse.jst.ws.internal.cxf.creation.ui.widgets.Java2WSClassConfigWidget;
import org.eclipse.jst.ws.internal.cxf.creation.ui.widgets.Java2WSInterfaceConfigWidget;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.INamedWidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.INamedWidgetContributorFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributorFactory;

public class Java2WSSelectSEIWidgetFactory
implements INamedWidgetContributorFactory {
    private static final String ENDPOINT_INTERFACE = "endpointInterface";
    private SimpleWidgetContributor classWidgetContributor;
    private SimpleWidgetContributor interfaceWidgetContributor;
    private Java2WSClassConfigWidget java2WSClassConfigWidget = new Java2WSClassConfigWidget();
    private Java2WSInterfaceConfigWidget java2WSInterfaceConfigWidget = new Java2WSInterfaceConfigWidget();
    private Java2WSDataModel model;
    private IType startingPointType;

    public INamedWidgetContributor getFirstNamedWidget() {
        if (this.startingPointType == null) {
            return null;
        }
        if (this.interfaceWidgetContributor == null || this.classWidgetContributor == null) {
            this.init();
        }
        try {
            if (this.startingPointType.isInterface()) {
                return this.interfaceWidgetContributor;
            }
            if (this.startingPointType.isClass()) {
                this.checkForServiceEndpointInterface();
                return this.classWidgetContributor;
            }
        }
        catch (JavaModelException jme) {
            CXFCreationUIPlugin.log(jme.getStatus());
        }
        return null;
    }

    private void checkForServiceEndpointInterface() throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = this.startingPointType.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (annotation.getElementName().equals(WebService.class.getSimpleName())) {
                IMemberValuePair[] memberValuePairs;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                    if (memberValuePair.getMemberName().equals(ENDPOINT_INTERFACE)) {
                        String endpointInterface = memberValuePair.getValue().toString();
                        IType seiType = this.startingPointType.getJavaProject().findType(endpointInterface);
                        if (seiType != null && seiType.exists()) {
                            this.model.setUseServiceEndpointInterface(true);
                            this.model.setFullyQualifiedJavaInterfaceName(endpointInterface);
                            this.model.setServiceEndpointInterfaceName(endpointInterface);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public INamedWidgetContributor getNextNamedWidget(INamedWidgetContributor widgetContributor) {
        return null;
    }

    public void registerDataMappings(DataMappingRegistry dataRegistry) {
        dataRegistry.addMapping(Java2WSDefaultingCommand.class, "Java2WSDataModel", Java2WSSelectSEIWidgetFactory.class);
        dataRegistry.addMapping(Java2WSDefaultingCommand.class, "JavaStartingPointType", Java2WSSelectSEIWidgetFactory.class);
    }

    public void setJava2WSDataModel(Java2WSDataModel model) {
        this.model = model;
        this.java2WSClassConfigWidget.setJava2WSDataModel(model);
        this.java2WSInterfaceConfigWidget.setJava2WSDataModel(model);
    }

    public void setJavaStartingPointType(IType startingPointType) {
        this.startingPointType = startingPointType;
        this.java2WSClassConfigWidget.setJavaStartingPointType(startingPointType);
        this.java2WSInterfaceConfigWidget.setJavaStartingPointType(startingPointType);
    }

    private void init() {
        this.classWidgetContributor = new SimpleWidgetContributor();
        Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
        String classConfigTitle = CXFCreationUIMessages.bind((String)CXFCreationUIMessages.JAVA2WS_CLASS_CONFIG_PAGE_TITLE, (Object[])new Object[]{context.getDefaultRuntimeType(), context.getDefaultRuntimeVersion()});
        this.classWidgetContributor.setTitle(classConfigTitle);
        this.classWidgetContributor.setDescription(CXFCreationUIMessages.JAVA2WS_CLASS_CONFIG_PAGE_DESCRIPTION);
        this.classWidgetContributor.setFactory(new WidgetContributorFactory(){

            public WidgetContributor create() {
                return Java2WSSelectSEIWidgetFactory.this.java2WSClassConfigWidget;
            }
        });
        this.interfaceWidgetContributor = new SimpleWidgetContributor();
        String interfaceConfigTitle = CXFCreationUIMessages.bind((String)CXFCreationUIMessages.JAVA2WS_INTERFACE_CONFIG_PAGE_TITLE, (Object[])new Object[]{context.getDefaultRuntimeType(), context.getDefaultRuntimeVersion()});
        this.interfaceWidgetContributor.setTitle(interfaceConfigTitle);
        this.interfaceWidgetContributor.setDescription(CXFCreationUIMessages.JAVA2WS_INTERFACE_CONFIG_PAGE_DESCRIPTION);
        this.interfaceWidgetContributor.setFactory(new WidgetContributorFactory(){

            public WidgetContributor create() {
                return Java2WSSelectSEIWidgetFactory.this.java2WSInterfaceConfigWidget;
            }
        });
    }
}

