/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreDestroyCallback
extends LifeCycleCallback {
    private static final Logger LOG = LoggerFactory.getLogger(PreDestroyCallback.class);

    public PreDestroyCallback(Class<?> clazz, String methodName) {
        super(clazz, methodName);
    }

    public PreDestroyCallback(String className, String methodName) {
        super(className, methodName);
    }

    @Override
    public void validate(Class<?> clazz, Method method) {
        if (method.getExceptionTypes().length > 0) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot not throw a checked exception");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot not have a return type");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot be static");
        }
    }

    @Override
    public void callback(Object instance) {
        try {
            super.callback(instance);
        }
        catch (Exception e) {
            LOG.warn("Ignoring exception thrown on preDestroy call to {}.{}", new Object[]{this.getTargetClass(), this.getTarget().getName(), e});
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof PreDestroyCallback;
    }
}

