/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.internal.driver.AbstractDTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterFactory;
import org.eclipse.jpt.jpa.db.internal.driver.FoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.LowerCaseFoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.SimpleCatalogStrategy;

class PostgreSQL
extends AbstractDTPDriverAdapter {
    private static final String PUBLIC_SCHEMA_NAME = "public";
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_'};
    private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[]{'$'};

    PostgreSQL(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new SimpleCatalogStrategy(this.database.getDTPDatabase());
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return LowerCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultCatalogNamesTo(ArrayList<String> names) {
        names.add(this.buildDefaultCatalogName());
    }

    private String buildDefaultCatalogName() {
        return ((Catalog)this.database.getDTPDatabase().getCatalogs().get(0)).getName();
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        super.addDefaultSchemaNamesTo(names);
        names.add(PUBLIC_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedRegularNamePartCharacters() {
        return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
    }

    static class Factory
    implements DTPDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"postgres"};

        Factory() {
        }

        @Override
        public String[] getSupportedVendors() {
            return VENDORS;
        }

        @Override
        public DTPDriverAdapter buildAdapter(Database database) {
            return new PostgreSQL(database);
        }
    }
}

