/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.ws.jaxws.dom.ui.internal.plugin.DomUi;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class Images {
    public static final Images INSTANCE = new Images();
    public static final String IMG_WEB_METHOD = "WebMethod";
    public static final String IMG_WEB_PARAM_IN = "WebParamIn";
    public static final String IMG_WEB_PARAM_OUT = "WebParamOut";
    public static final String IMG_WEB_SERVICE = "WebService";
    public static final String IMG_WEB_SERVICE_GROUP = "WebServiceGroup";
    public static final String IMG_SEI = "SEI";
    public static final String IMG_SEI_GROUP = "SEIGroup";
    public static final String IMG_DOM_WS_PROVIDER = "DOMWSProvider";
    public static final String IMG_ERROR_MARKER = "error_obj";
    public static final String IMG_WARNING_MARKER = "warning_obj";
    private static ResourceBundle iconsBundle;
    private static ImageRegistry mImageRegistry;

    public Images() {
        try {
            iconsBundle = ResourceBundle.getBundle("org.eclipse.jst.ws.jaxws.dom.ui.internal.plugin.WSImageBundle");
        }
        catch (MissingResourceException x) {
            new Logger().logError("Unable to load image bundle for this plugin!", (Throwable)x);
            iconsBundle = null;
        }
    }

    protected void initializeImageRegistry() {
        try {
            mImageRegistry = new ImageRegistry();
            mImageRegistry.put(IMG_WEB_SERVICE, Images.getImageResource(iconsBundle.getString("IMG_WEB_SERVICE")));
            mImageRegistry.put(IMG_WEB_SERVICE_GROUP, Images.getImageResource(iconsBundle.getString("IMG_WEB_SERVICE_GROUP")));
            mImageRegistry.put(IMG_SEI, Images.getImageResource(iconsBundle.getString("IMG_SEI")));
            mImageRegistry.put(IMG_SEI_GROUP, Images.getImageResource(iconsBundle.getString("IMG_SEI_GROUP")));
            mImageRegistry.put(IMG_DOM_WS_PROVIDER, Images.getImageResource(iconsBundle.getString("IMG_DOM_WS_PROVIDER")));
            mImageRegistry.put(IMG_WEB_METHOD, Images.getImageResource(iconsBundle.getString("IMG_WEB_METHOD")));
            mImageRegistry.put(IMG_WEB_PARAM_IN, Images.getImageResource(iconsBundle.getString("IMG_WEB_PARAM_IN")));
            mImageRegistry.put(IMG_WEB_PARAM_OUT, Images.getImageResource(iconsBundle.getString("IMG_WEB_PARAM_OUT")));
            mImageRegistry.put(IMG_ERROR_MARKER, Images.getImageResource(iconsBundle.getString("IMG_ERROR_MARKER")));
            mImageRegistry.put(IMG_WARNING_MARKER, Images.getImageResource(iconsBundle.getString("IMG_WARNING_MARKER")));
        }
        catch (RuntimeException e) {
            new Logger().logError("Unable to initialize image registry !", (Throwable)e);
        }
    }

    public ImageRegistry getImageRegistry() {
        if (mImageRegistry == null) {
            this.initializeImageRegistry();
        }
        return mImageRegistry;
    }

    public Image getImage(String imageName) {
        return INSTANCE.getImageRegistry().get(imageName);
    }

    public static ImageDescriptor getImageResourceByKey(String resourceName) {
        return Images.getImageResource(iconsBundle.getString(resourceName));
    }

    public static ImageDescriptor getImageResource(String resourceName) {
        try {
            URL url = DomUi.getDefault().getBundle().getResource(resourceName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (NullPointerException npe) {
            new Logger().logError(MessageFormat.format("Unable to locate resource {0}!", resourceName), (Throwable)npe);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

