/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryConfiglModelSource;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryRegistryUtil;
import org.eclipse.osgi.util.NLS;

public class JAXRSLibraryConfigProjectData
implements JAXRSLibraryConfiglModelSource {
    static final String QUALIFIEDNAME = "org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryConfigProjectData";
    protected static final String SPTR_TUPLE = ":";
    protected static final String EO_TUPLE = ";";
    private final IProject project;
    private final JAXRSLibraryRegistryUtil jaxrsLibReg;
    private JAXRSLibraryInternalReference selJAXRSLibImpl;

    public JAXRSLibraryConfigProjectData(IProject project) {
        this.project = project;
        this.jaxrsLibReg = JAXRSLibraryRegistryUtil.getInstance();
        if (!this.isProjectFirstCreated()) {
            this.verifySavedLibAvailability();
        }
    }

    @Override
    public JAXRSLibraryInternalReference getJAXRSImplementationLibrary() {
        try {
            if (!this.isProjectFirstCreated() && this.selJAXRSLibImpl == null) {
                String strImplLibs = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jaxrs.implementation.libraries"));
                this.selJAXRSLibImpl = this.getJAXRSImplLibfromPersistentProperties(this.getTuples(strImplLibs));
            }
        }
        catch (CoreException e) {
            JAXRSCorePlugin.log((Exception)((Object)e), "Exception occured while returning reference to the JAXRS implementation library");
        }
        return this.selJAXRSLibImpl;
    }

    void saveData(List implementation) {
        try {
            this.project.setPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jaxrs.implementation.libraries"), this.generatePersistString(implementation));
            this.selJAXRSLibImpl = null;
        }
        catch (CoreException e) {
            JAXRSCorePlugin.log((Exception)((Object)e), "Exception occured while persisting the JAXRS Library preferences");
        }
    }

    private boolean isProjectFirstCreated() {
        boolean isNew = false;
        try {
            this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jaxrs.implementation.libraries"));
        }
        catch (CoreException coreException) {
            isNew = true;
        }
        return isNew;
    }

    private void verifySavedLibAvailability() {
        try {
            String strImplLibs = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jaxrs.implementation.libraries"));
            this.logMissingLib(this.getTuples(strImplLibs), true);
        }
        catch (CoreException e) {
            JAXRSCorePlugin.log((Exception)((Object)e), "Exception occured while verifying saved JAXRS Library preferences");
        }
    }

    private void logMissingLib(List<Tuple> jaxrsLibTuples, boolean isVerifyImpl) {
        if (this.jaxrsLibReg != null) {
            for (Tuple tuple : jaxrsLibTuples) {
                JAXRSLibraryInternalReference jaxrsLib = this.jaxrsLibReg.getJAXRSLibraryReferencebyID(tuple.getID());
                if (jaxrsLib != null) continue;
                String prjName = this.project.getName();
                String msg = isVerifyImpl ? Messages.JAXRSLibraryConfigPersistData_SAVED_IMPLLIB_NOT_FOUND : Messages.JAXRSLibraryConfigPersistData_SAVED_COMPLIB_NOT_FOUND;
                JAXRSCorePlugin.log(1, NLS.bind((String)msg, (Object)prjName));
            }
        }
    }

    private JAXRSLibraryInternalReference getJAXRSImplLibfromPersistentProperties(List<Tuple> jaxrsLibTuples) {
        if (this.jaxrsLibReg != null) {
            Tuple tuple2 = null;
            JAXRSLibraryInternalReference lib = null;
            for (Tuple tuple2 : jaxrsLibTuples) {
                lib = this.jaxrsLibReg.getJAXRSLibraryReferencebyID(tuple2.id);
                if (lib == null) continue;
                return new JAXRSLibraryInternalReference(lib.getLibrary(), tuple2.selected, tuple2.deploy, tuple2.sharedLib);
            }
        }
        return null;
    }

    private String generatePersistString(List list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            JAXRSLibraryInternalReference jaxrsLibItem = (JAXRSLibraryInternalReference)list.get(i);
            sb = sb.append(jaxrsLibItem.generatePersistString());
            sb.append(EO_TUPLE);
            ++i;
        }
        return sb.toString();
    }

    private List<Tuple> getTuples(String strJAXRSLibs) {
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        if (strJAXRSLibs != null) {
            String patternStr = EO_TUPLE;
            String[] fields = strJAXRSLibs.split(patternStr);
            if (strJAXRSLibs.length() > 0) {
                int i = 0;
                while (i < fields.length) {
                    Tuple tuple = new Tuple(fields[i]);
                    list.add(tuple);
                    ++i;
                }
            }
        }
        return list;
    }

    static class Tuple {
        private final String id;
        private final boolean selected;
        private final boolean deploy;
        private final boolean sharedLib;

        Tuple(String id, boolean selected, boolean deploy, boolean sharedLib) {
            this.id = id;
            this.selected = selected;
            this.deploy = deploy;
            this.sharedLib = sharedLib;
        }

        Tuple(String tuple) {
            String[] fields = tuple.split(JAXRSLibraryConfigProjectData.SPTR_TUPLE);
            if (fields.length < 4) {
                throw new IllegalStateException("Library registry is corrupt");
            }
            this.id = fields[0];
            this.selected = Boolean.valueOf(fields[1]);
            this.deploy = Boolean.valueOf(fields[2]);
            this.sharedLib = Boolean.valueOf(fields[3]);
        }

        String getID() {
            return this.id;
        }

        boolean isSelected() {
            return this.selected;
        }

        boolean needDeploy() {
            return this.deploy;
        }

        boolean needSharedLib() {
            return this.sharedLib;
        }
    }
}

