/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.clazz;

import java.io.File;
import java.io.FileWriter;
import junit.framework.TestCase;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jst.ws.jaxws.testutils.files.TestFileUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.utils.clazz.ASTUtils;

public class ASTUtilsTest
extends TestCase {
    private static final String PCK = "org.eclipse.test";
    private static final String SRC = "import javax.xml.namespace.QName;\npublic class Test {\n\tprivate final static String name = \"are\";\n   public Test() {}\n\tpublic int createInt() {return 0;}\n}";
    private TestProject project;

    public void manualSetUp() throws Exception {
        this.project = new TestProject("JavaProj_" + System.currentTimeMillis());
        this.project.createSourceFolder("src");
    }

    public void tearDown() throws Exception {
        if (this.project != null) {
            this.project.dispose();
        }
    }

    public void testCreateASTFileNpe() throws Exception {
        try {
            ASTUtils.getInstance().createAST(null, null);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testCreateASTFile() throws Exception {
        File tempJavaFile = this.createTempJavaFile();
        ASTNode node = ASTUtils.getInstance().createAST(tempJavaFile, null);
        ASTUtilsTest.assertNotNull((Object)node);
        ASTUtilsTest.assertTrue((boolean)(node instanceof CompilationUnit));
    }

    public void testCreateASTITypeNpe() throws Exception {
        try {
            ASTUtils.getInstance().createCompilationUnit(null, null);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testCreateASTIType() throws Exception {
        this.manualSetUp();
        IType sourceType = this.project.createType(this.project.createPackage(PCK), "Test.java", SRC);
        CompilationUnit node = ASTUtils.getInstance().createCompilationUnit(sourceType.getCompilationUnit(), null);
        ASTUtilsTest.assertNotNull((Object)node);
        ASTUtilsTest.assertTrue((boolean)(node instanceof CompilationUnit));
    }

    public void testGetTypeDeclaration() throws Exception {
        this.manualSetUp();
        IType sourceType = this.project.createType(this.project.createPackage(PCK), "Test.java", SRC);
        CompilationUnit unit = ASTUtils.getInstance().createCompilationUnit(sourceType.getCompilationUnit(), null);
        AbstractTypeDeclaration abstractType = ASTUtils.getInstance().getTypeDeclaration("Test", unit);
        ASTUtilsTest.assertNotNull((Object)abstractType);
    }

    public void testGetTypeDeclarationForInnerType() throws Exception {
        this.manualSetUp();
        String source = "public class Test {public static class Parameters {}}";
        IType sourceType = this.project.createType(this.project.createPackage(PCK), "Test.java", source);
        CompilationUnit unit = ASTUtils.getInstance().createCompilationUnit(sourceType.getCompilationUnit(), null);
        AbstractTypeDeclaration abstractType = ASTUtils.getInstance().getTypeDeclaration("Parameters", unit);
        ASTUtilsTest.assertNotNull((Object)abstractType);
    }

    public void testGetTypeSignatureForSimpleType() throws Exception {
        String varArgSignature = this.getTypeSignatureForParameter("String p");
        ASTUtilsTest.assertFalse((String)"Signature should not start with '['", (varArgSignature.toCharArray()[0] == '[' ? 1 : 0) != 0);
    }

    public void testGetTypeSignatureForArray() throws Exception {
        String varArgSignature = this.getTypeSignatureForParameter("String[] p");
        ASTUtilsTest.assertTrue((String)"Signature should start with '['", (varArgSignature.toCharArray()[0] == '[' ? 1 : 0) != 0);
        ASTUtilsTest.assertFalse((String)"Signature second caharacter must not be '['", (varArgSignature.toCharArray()[1] == '[' ? 1 : 0) != 0);
    }

    public void testGetTypeSignatureForVarArg() throws Exception {
        String varArgSignature = this.getTypeSignatureForParameter("String... p");
        ASTUtilsTest.assertTrue((String)"Signature should start with '['", (varArgSignature.toCharArray()[0] == '[' ? 1 : 0) != 0);
        ASTUtilsTest.assertFalse((String)"Signature second caharacter must not be '['", (varArgSignature.toCharArray()[1] == '[' ? 1 : 0) != 0);
    }

    public void testGetTypeSignatureForMultiDimensionalVarArg() throws Exception {
        String varArgSignature = this.getTypeSignatureForParameter("String[][]... p");
        ASTUtilsTest.assertTrue((String)"Signature should start with '['", (varArgSignature.toCharArray()[0] == '[' ? 1 : 0) != 0);
        ASTUtilsTest.assertTrue((String)"Signature second caharacter must be '['", (varArgSignature.toCharArray()[1] == '[' ? 1 : 0) != 0);
        ASTUtilsTest.assertTrue((String)"Signature third caharacter must be '['", (varArgSignature.toCharArray()[2] == '[' ? 1 : 0) != 0);
        ASTUtilsTest.assertFalse((String)"Signature fourth characted must not be '['", (varArgSignature.toCharArray()[3] == '[' ? 1 : 0) != 0);
    }

    private String getTypeSignatureForParameter(String paramDefinition) throws Exception {
        ASTUtils astUtils = ASTUtils.getInstance();
        this.manualSetUp();
        String source = "public class Test { public void varArgMethod(" + paramDefinition + "){} }";
        IType sourceType = this.project.createType(this.project.createPackage(PCK), "Test.java", source);
        IMethod varargMethod = sourceType.getMethods()[0];
        ASTUtilsTest.assertEquals((String)"Unexpected method name", (String)"varArgMethod", (String)varargMethod.getElementName());
        CompilationUnit unit = astUtils.createCompilationUnit(sourceType.getCompilationUnit(), null);
        MethodDeclaration methodDecl = astUtils.getMethodDeclaration(varargMethod, (TypeDeclaration)astUtils.getTypeDeclaration("Test", unit));
        ASTUtilsTest.assertEquals((String)"One parameter expected", (int)1, (int)methodDecl.parameters().size());
        return astUtils.getTypeSignature((SingleVariableDeclaration)methodDecl.parameters().iterator().next());
    }

    private File createTempJavaFile() throws Exception {
        File dir = TestFileUtils.createTempDirectory((String)("" + System.currentTimeMillis()));
        File tempClassFile = new File(dir, "Test.java");
        FileWriter fw = new FileWriter(tempClassFile);
        fw.write("package org.eclipse.test;\nimport javax.xml.namespace.QName;\npublic class Test {\n\tprivate final static String name = \"are\";\n   public Test() {}\n\tpublic int createInt() {return 0;}\n}");
        fw.close();
        return tempClassFile;
    }
}

