/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class Trace
implements DebugOptionsListener {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
    public static Set<String> logged = new HashSet<String>();
    public static boolean CONFIG = false;
    public static boolean INFO = false;
    public static boolean WARNING = false;
    public static boolean SEVERE = false;
    public static boolean FINEST = false;
    public static boolean FINER = false;
    public static boolean PERFORMANCE = false;
    public static boolean EXTENSION_POINT = false;
    public static final String STRING_CONFIG = "/config";
    public static final String STRING_INFO = "/info";
    public static final String STRING_WARNING = "/warning";
    public static final String STRING_SEVERE = "/severe";
    public static final String STRING_FINEST = "/finest";
    public static final String STRING_FINER = "/finer";
    public static final String STRING_EXTENSION_POINT = "/extension_point";
    public static final String STRING_PERFORMANCE = "/performance";

    public void optionsChanged(DebugOptions options) {
        CONFIG = options.getBooleanOption("org.eclipse.wst.server.ui/config", false);
        INFO = options.getBooleanOption("org.eclipse.wst.server.ui/info", false);
        WARNING = options.getBooleanOption("org.eclipse.wst.server.ui/warning", false);
        SEVERE = options.getBooleanOption("org.eclipse.wst.server.ui/severe", false);
        FINER = options.getBooleanOption("org.eclipse.wst.server.ui/finer", false);
        FINEST = options.getBooleanOption("org.eclipse.wst.server.ui/finest", false);
        EXTENSION_POINT = options.getBooleanOption("org.eclipse.wst.server.ui/extension_point", false);
        PERFORMANCE = options.getBooleanOption("org.eclipse.wst.server.ui/performance", false);
    }

    public static void trace(String level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(String level, String s, Throwable t) {
        if (s == null) {
            return;
        }
        if (STRING_SEVERE.equals(level) && !logged.contains(s)) {
            ServerUIPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.wst.server.ui", s, t));
            logged.add(s);
        }
        if (ServerUIPlugin.getInstance().isDebugging()) {
            StringBuffer sb = new StringBuffer("org.eclipse.wst.server.ui");
            sb.append(" ");
            sb.append(level);
            sb.append(" ");
            sb.append(sdf.format(new Date()));
            sb.append(" ");
            sb.append(s);
            System.out.println(sb.toString());
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

