/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;

public class PluginUtil {
    private static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";

    public static void openProjectExplorerView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && workbench.getWorkbenchWindowCount() == 1) {
                    window = workbench.getWorkbenchWindows()[0];
                }
                if (window != null) {
                    try {
                        window.getActivePage().showView(PluginUtil.PROJECT_EXPLORER_ID);
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        });
    }

    public static boolean isChromiumDebugFile(IFile file) {
        IProject project = file.getProject();
        try {
            return project.hasNature("org.eclipse.wst.jsdt.chromium.debug.core.jsnature") && file.getName().endsWith(".chromium");
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)e);
            return false;
        }
    }

    public static String stripChromiumExtension(String fileName, boolean check) {
        if (check && !fileName.endsWith(".chromium")) {
            return fileName;
        }
        return fileName.substring(0, fileName.length() - ".chromium".length());
    }

    public static FontMetrics getFontMetrics(Drawable drawable, Font font) {
        GC gc = new GC(drawable);
        try {
            if (font != null) {
                gc.setFont(font);
            }
            FontMetrics fontMetrics = gc.getFontMetrics();
            return fontMetrics;
        }
        finally {
            gc.dispose();
        }
    }

    private PluginUtil() {
    }
}

