/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchEditResourceHandler;
import org.eclipse.wst.common.internal.emfworkbench.edit.ClientAccessRegistryException;
import org.eclipse.wst.common.internal.emfworkbench.edit.Snapshot;

public class ClientAccessRegistry {
    protected final WeakHashMap registry = new WeakHashMap();
    protected final Set baseSet = new HashSet();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void access(Object accessorKey) {
        if (this.isStable()) {
            if (this.registry.containsKey(accessorKey)) throw new ClientAccessRegistryException(EMFWorkbenchEditResourceHandler.ClientAccessRegistry_ERROR_0, accessorKey);
            Snapshot snapshot = new Snapshot();
            this.registry.put(accessorKey, snapshot);
            this.baseSet.add(snapshot);
            return;
        } else {
            this.complain();
        }
    }

    public synchronized void release(Object accessorKey) {
        if (this.registry.containsKey(accessorKey) && this.isStable()) {
            Snapshot snapshot = (Snapshot)this.registry.remove(accessorKey);
            this.baseSet.remove(snapshot);
        } else {
            this.complain(accessorKey);
        }
    }

    public synchronized void assertAccess(Object accessorKey) {
        if (!this.isClientAccessing(accessorKey)) {
            throw new ClientAccessRegistryException(EMFWorkbenchResourceHandler.getString((String)"ClientAccessRegistry_ERROR_1"), accessorKey);
        }
    }

    public synchronized boolean isClientAccessing(Object client) {
        boolean result = this.registry.containsKey(client);
        if (!this.isStable()) {
            this.complain();
        }
        return result;
    }

    public synchronized boolean isAnyClientAccessing() {
        boolean result;
        boolean bl = result = this.registry.size() > 0;
        if (!this.isStable()) {
            this.complain();
        }
        return result;
    }

    public synchronized boolean isStable() {
        return this.baseSet.size() == this.registry.size();
    }

    public void complain() {
        this.complain(null);
    }

    public void complain(Object accessorKey) {
        if (!this.isStable()) {
            throw new ClientAccessRegistryException(this.registry, this.baseSet);
        }
        throw new ClientAccessRegistryException(EMFWorkbenchResourceHandler.getString((String)"ClientAccessRegistry_ERROR_1"), accessorKey);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("ClientAccessRegistry: [");
        result.append(this.isStable() ? "STABLE" : "OUT OF SYNC");
        result.append("]: Reference Count = ");
        result.append(this.size());
        return result.toString();
    }

    public synchronized int size() {
        return this.registry.size();
    }
}

