/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLComplexTypeMetadata;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;

public class PLSQLTableMetadata
extends PLSQLComplexTypeMetadata {
    private String nestedType;
    private Boolean isNestedTable;

    public PLSQLTableMetadata() {
        super("<plsql-table>");
    }

    public PLSQLTableMetadata(MetadataAnnotation record, MetadataAccessor accessor) {
        super(record, accessor);
        this.nestedType = record.getAttributeString("nestedType");
        this.isNestedTable = record.getAttributeBooleanDefaultFalse("isNestedTable");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PLSQLTableMetadata) {
            PLSQLTableMetadata parameter = (PLSQLTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.isNestedTable, parameter.getNestedTable())) {
                return false;
            }
            if (!this.valuesMatch(this.nestedType, parameter.getNestedType())) {
                return false;
            }
        }
        return super.equals(objectToCompare);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nestedType != null ? this.nestedType.hashCode() : 0);
        result = 31 * result + (this.isNestedTable != null ? this.isNestedTable.hashCode() : 0);
        return result;
    }

    public Boolean getNestedTable() {
        return this.isNestedTable;
    }

    public String getNestedType() {
        return this.nestedType;
    }

    public boolean isNestedTable() {
        return this.getNestedTable() != null && this.getNestedTable() != false;
    }

    public PLSQLCollection process() {
        PLSQLCollection table = new PLSQLCollection();
        super.process((ComplexDatabaseType)table);
        table.setIsNestedTable(this.isNestedTable());
        table.setNestedType(this.getDatabaseTypeEnum(this.getNestedType()));
        return table;
    }

    public void setNestedTable(Boolean isNestedTable) {
        this.isNestedTable = isNestedTable;
    }

    public void setNestedType(String nestedType) {
        this.nestedType = nestedType;
    }

    @Override
    public boolean isPLSQLTableMetadata() {
        return true;
    }
}

