/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.NotifyingRepeatingCommand;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.command.RepeatingCommandWrapper;
import org.eclipse.jpt.common.utility.internal.model.ModelTools;

public class NotifyingRepeatingCommandWrapper
extends RepeatingCommandWrapper
implements NotifyingRepeatingCommand {
    private final ListenerList<NotifyingRepeatingCommand.Listener> listenerList = ModelTools.listenerList();

    public NotifyingRepeatingCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        super(command, exceptionHandler);
    }

    public NotifyingRepeatingCommandWrapper(Command command, CommandContext startCommandContext, ExceptionHandler exceptionHandler) {
        super(command, startCommandContext, exceptionHandler);
    }

    @Override
    public void addListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    void executeCommand() {
        super.executeCommand();
        if (this.state.isQuiesced()) {
            this.executionQuiesced();
        }
    }

    private void executionQuiesced() {
        for (NotifyingRepeatingCommand.Listener listener : this.listenerList) {
            try {
                listener.executionQuiesced(this);
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleException(ex);
            }
        }
    }
}

