/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.common.util;

import java.util.Iterator;
import org.apache.axis.model.common.util.BasicEList;
import org.apache.axis.model.common.util.TreeIterator;

public abstract class AbstractTreeIterator
extends BasicEList
implements TreeIterator {
    protected boolean includeRoot;
    protected Object object;
    protected Iterator nextPruneIterator;
    protected Iterator nextRemoveIterator;

    public AbstractTreeIterator(Object object) {
        this.object = object;
        this.includeRoot = true;
    }

    public AbstractTreeIterator(Object object, boolean includeRoot) {
        this.object = object;
        this.includeRoot = includeRoot;
    }

    protected abstract Iterator getChildren(Object var1);

    public boolean hasNext() {
        if (this.data == null && !this.includeRoot) {
            return this.hasAnyChildren();
        }
        return this.hasMoreChildren();
    }

    private boolean hasAnyChildren() {
        Iterator nextPruneIterator = this.nextPruneIterator;
        nextPruneIterator = this.getChildren(this.object);
        this.add(nextPruneIterator);
        return nextPruneIterator.hasNext();
    }

    private boolean hasMoreChildren() {
        return this.data == null || !this.isEmpty() && ((Iterator)this.data[this.size - 1]).hasNext();
    }

    public Object next() {
        Object result;
        if (this.data == null) {
            result = this.object;
            this.nextPruneIterator = this.getChildren(this.object);
            this.add(this.nextPruneIterator);
            if (this.includeRoot) {
                return result;
            }
        }
        Iterator currentIterator = (Iterator)this.data[this.size - 1];
        result = currentIterator.next();
        this.nextRemoveIterator = currentIterator;
        Iterator iterator = this.getChildren(result);
        if (iterator.hasNext()) {
            this.nextPruneIterator = iterator;
            this.add(iterator);
        } else {
            this.nextPruneIterator = null;
            while (!currentIterator.hasNext()) {
                this.data[--this.size] = null;
                if (this.isEmpty()) break;
                currentIterator = (Iterator)this.data[this.size - 1];
            }
        }
        return result;
    }

    public void remove() {
        if (this.nextRemoveIterator == null) {
            throw new IllegalStateException("There is no valid object to remove.");
        }
        this.nextRemoveIterator.remove();
    }

    public void prune() {
        if (this.nextPruneIterator != null) {
            if (!this.isEmpty() && this.data[this.size - 1] == this.nextPruneIterator) {
                this.data[--this.size] = null;
                while (!this.isEmpty() && !((Iterator)this.data[this.size - 1]).hasNext()) {
                    this.data[--this.size] = null;
                }
            }
            this.nextPruneIterator = null;
        }
    }
}

