/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.html5.model;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.contentmodel.HTML5AttributeCollection;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLAttributeDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class HTML5ContentModelTest
extends TestCase {
    public HTML5ContentModelTest(String name) {
        super(name);
    }

    private void checkAttrNames(String documentKey, String elementName, String[] attrNames) {
        CMDocument document = HTMLCMDocumentFactory.getCMDocument((String)documentKey);
        CMNode elementDeclaration = document.getElements().getNamedItem(elementName);
        HTML5ContentModelTest.assertNotNull((String)("no such element declaration:" + elementName), (Object)elementDeclaration);
        HTML5ContentModelTest.assertEquals((String)("not an element declaration:" + String.valueOf(elementDeclaration)), (int)5, (int)elementDeclaration.getNodeType());
        CMNamedNodeMap attributes = ((CMElementDeclaration)elementDeclaration).getAttributes();
        StringBuilder actualNames = new StringBuilder();
        int i = 0;
        while (i < attrNames.length) {
            actualNames.append(attrNames[i]);
            HTML5ContentModelTest.assertNotNull((String)("missing attribute declaration:" + attrNames[i] + " for element: " + elementName), (Object)attributes.getNamedItem(attrNames[i]));
            ++i;
            actualNames.append(',');
        }
        HTML5ContentModelTest.assertEquals((String)("Attributes defined in content model that are not expected by the test for element: " + elementName), (int)attributes.getLength(), (int)attrNames.length);
    }

    private void checkAttrNames(String documentKey, String elementName, String[] attrNames, String sortedExpectedNames) {
        CMDocument document = HTMLCMDocumentFactory.getCMDocument((String)documentKey);
        CMNode elementDeclaration = document.getElements().getNamedItem(elementName);
        HTML5ContentModelTest.assertNotNull((String)("no such element declaration:" + elementName), (Object)elementDeclaration);
        HTML5ContentModelTest.assertEquals((String)("not an element declaration:" + String.valueOf(elementDeclaration)), (int)5, (int)elementDeclaration.getNodeType());
        CMNamedNodeMap attributes = ((CMElementDeclaration)elementDeclaration).getAttributes();
        StringBuilder actualNames = new StringBuilder();
        Arrays.sort(attrNames);
        int i = 0;
        while (i < attrNames.length) {
            actualNames.append(attrNames[i]);
            HTML5ContentModelTest.assertNotNull((String)("missing attribute declaration:" + attrNames[i] + " for element: " + elementName), (Object)attributes.getNamedItem(attrNames[i]));
            ++i;
            actualNames.append('\n');
        }
        HTML5ContentModelTest.assertEquals((String)"List of attribute names does not match", (String)sortedExpectedNames, (String)actualNames.toString());
        HTML5ContentModelTest.assertEquals((String)("Attributes defined in content model that are not expected by the test for element: " + elementName), (int)attributes.getLength(), (int)attrNames.length);
    }

    private void checkAttrValues(String documentKey, String elementName, String attrName, String[] attrValues) {
        CMDocument document = HTMLCMDocumentFactory.getCMDocument((String)documentKey);
        CMNode elementDeclaration = document.getElements().getNamedItem(elementName);
        HTML5ContentModelTest.assertEquals((String)("not an element declaration:" + String.valueOf(elementDeclaration)), (int)5, (int)elementDeclaration.getNodeType());
        HTML5ContentModelTest.assertNotNull((String)("missing element declaration:" + elementName), (Object)elementDeclaration);
        CMNamedNodeMap attributes = ((CMElementDeclaration)elementDeclaration).getAttributes();
        CMNode node = attributes.getNamedItem(attrName);
        HTML5ContentModelTest.assertNotNull((String)("No attribute [" + attrName + "]"), (Object)node);
        String[] actualValues = ((HTMLAttributeDeclaration)node).getAttrType().getEnumeratedValues();
        HTML5ContentModelTest.assertEquals((int)attrValues.length, (int)actualValues.length);
        HashSet<String> valueSet = new HashSet<String>(actualValues.length);
        int i = 0;
        while (i < actualValues.length) {
            valueSet.add(actualValues[i]);
            ++i;
        }
        i = 0;
        while (i < attrValues.length) {
            if (!valueSet.remove(attrValues[i])) {
                HTML5ContentModelTest.fail((String)("Type did not contain attribute value [" + attrValues[i] + "]"));
            }
            ++i;
        }
        HTML5ContentModelTest.assertTrue((String)"Type had unexpected attribute values", (boolean)valueSet.isEmpty());
    }

    private void checkDocument(Object documentKey) {
        CMDocument document = HTMLCMDocumentFactory.getCMDocument((String)documentKey.toString());
        HTML5ContentModelTest.assertNotNull((String)("missing doc:" + documentKey.toString()), (Object)document);
        CMNamedNodeMap elements = document.getElements();
        int i = 0;
        while (i < elements.getLength()) {
            CMNode item = elements.item(i);
            HTML5ContentModelTest.assertNotNull((String)(String.valueOf(documentKey) + " contained a null element declaration at index " + i), (Object)item);
            this.verifyElementDeclarationHasName(item);
            ++i;
        }
    }

    private String[] getMergedlist(String[] list1, String[] list2) {
        String[] mergerList = new String[list1.length + list2.length];
        System.arraycopy(list1, 0, mergerList, 0, list1.length);
        System.arraycopy(list2, 0, mergerList, list1.length, list2.length);
        return mergerList;
    }

    private String[] getGlobalList() {
        return this.getMergedlist(HTML5AttributeCollection.getGlobalAttributeList(), HTML5AttributeCollection.getGlobalEventList());
    }

    public void testAttributesOnHTML5Article() {
        this.checkAttrNames("HTML5", "article", this.getGlobalList());
    }

    public void testAttributesOnHTML5Aside() {
        this.checkAttrNames("HTML5", "aside", this.getGlobalList());
    }

    public void testAttributesOnHTML5Canvas() {
        this.checkAttrNames("HTML5", "canvas", this.getMergedlist(this.getGlobalList(), new String[]{"height", "width"}));
    }

    public void testAttributesOnHTML5Command() {
        this.checkAttrNames("HTML5", "command", this.getMergedlist(this.getGlobalList(), new String[]{"type", "label", "icon", "disabled", "checked", "radiogroup"}));
    }

    public void testAttributesOnHTML5Datalist() {
        this.checkAttrNames("HTML5", "datalist", this.getGlobalList());
    }

    public void testAttributesOnHTML5Details() {
        this.checkAttrNames("HTML5", "details", this.getMergedlist(this.getGlobalList(), new String[]{"open"}));
    }

    public void testAttributesOnHTML5Figure() {
        this.checkAttrNames("HTML5", "figure", this.getGlobalList());
    }

    public void testAttributesOnHTML5FigCaption() {
        this.checkAttrNames("HTML5", "figcaption", this.getGlobalList());
    }

    public void testAttributesOnHTML5Header() {
        this.checkAttrNames("HTML5", "header", this.getGlobalList());
    }

    public void testAttributesOnHTML5HGroup() {
        this.checkAttrNames("HTML5", "hgroup", this.getGlobalList());
    }

    public void testAttributesOnHTML5Keygen() {
        this.checkAttrNames("HTML5", "keygen", this.getMergedlist(this.getGlobalList(), new String[]{"challenge", "disabled", "form", "keytype", "name"}), "accesskey\nautocapitalize\nautofocus\nchallenge\nclass\ncontenteditable\ncontextmenu\ndir\ndisabled\ndraggable\ndropzone\nenterkeyhint\nform\nhidden\nid\ninputmode\nis\nitemid\nitemprop\nitemref\nitemscope\nitemtype\nkeytype\nlang\nname\nnonce\nonabort\nonblur\noncancel\noncanplay\noncanplaythrough\nonchange\nonclick\nonclose\noncontextmenu\noncuechange\nondblclick\nondrag\nondragend\nondragenter\nondragexit\nondragleave\nondragover\nondragstart\nondrop\nondurationchange\nonemptied\nonended\nonerror\nonfocus\nonformchange\nonforminput\noninput\noninvalid\nonkeydown\nonkeypress\nonkeyup\nonload\nonloadeddata\nonloadedmetadata\nonloadstart\nonmousedown\nonmouseenter\nonmouseleave\nonmousemove\nonmouseout\nonmouseover\nonmouseup\nonmousewheel\nonpause\nonplay\nonplaying\nonprogress\nonratechange\nonreadystatechange\nonreset\nonresize\nonscroll\nonseeked\nonseeking\nonselect\nonshow\nonstalled\nonsubmit\nonsuspend\nontimeupdate\nontoggle\nonvolumechange\nonvolumeupdate\nonwaiting\nrole\nslot\nspellcheck\nstyle\ntabindex\ntitle\ntranslate\n");
    }

    public void testAttributesOnHTML5Main() {
        this.checkAttrNames("HTML5", "main", this.getGlobalList());
    }

    public void testAttributesOnHTML5Mark() {
        this.checkAttrNames("HTML5", "mark", this.getGlobalList());
    }

    public void testAttributesOnHTML5Math() {
        this.checkAttrNames("HTML5", "math", this.getGlobalList());
    }

    public void testAttributesOnHTML5Meter() {
        this.checkAttrNames("HTML5", "meter", this.getMergedlist(this.getGlobalList(), new String[]{"max", "min", "low", "high", "optimum", "form", "value"}));
    }

    public void testAttributesOnHTML5Nav() {
        this.checkAttrNames("HTML5", "nav", this.getGlobalList());
    }

    public void testAttributesOnHTML5Output() {
        this.checkAttrNames("HTML5", "output", this.getMergedlist(this.getGlobalList(), new String[]{"for", "form", "name"}));
    }

    public void testAttributesOnHTML5Progress() {
        this.checkAttrNames("HTML5", "progress", this.getMergedlist(this.getGlobalList(), new String[]{"value", "max", "form"}));
    }

    public void testAttributesOnHTML5RT() {
        this.checkAttrNames("HTML5", "rt", this.getGlobalList());
    }

    public void testAttributesOnHTML5RP() {
        this.checkAttrNames("HTML5", "rp", this.getGlobalList());
    }

    public void testAttributesOnHTML5Ruby() {
        this.checkAttrNames("HTML5", "ruby", this.getGlobalList());
    }

    public void testAttributesOnHTML5Section() {
        this.checkAttrNames("HTML5", "section", this.getGlobalList());
    }

    public void testAttributesOnHTML5Source() {
        this.checkAttrNames("HTML5", "source", this.getMergedlist(this.getGlobalList(), new String[]{"src", "type", "media"}));
    }

    public void testAttributesOnHTML5Summary() {
        this.checkAttrNames("HTML5", "summary", this.getGlobalList());
    }

    public void testAttributesOnHTML5SVG() {
        this.checkAttrNames("HTML5", "svg", this.getGlobalList());
    }

    public void testAttributesOnHTML5Table() {
        this.checkAttrValues("HTML5", "TABLE", "border", new String[]{"", "1"});
    }

    public void testAttributesOnHTML5Time() {
        this.checkAttrNames("HTML5", "time", this.getMergedlist(this.getGlobalList(), new String[]{"datetime", "pubdate"}));
    }

    public void testAttributesOnHTML5InputTypes() {
        this.checkAttrValues("HTML5", "INPUT", "type", new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button", "color", "date", "datetime", "datetime-local", "email", "month", "number", "range", "search", "tel", "time", "week", "url"});
    }

    public void testAttributesOnHTML5Body() {
        this.checkAttrNames("HTML5", "BODY", this.getMergedlist(this.getMergedlist(this.getGlobalList(), HTML5AttributeCollection.getBodyEventList()), new String[]{"bgcolor", "text", "link", "onload", "onunload", "background", "marginwidth", "marginheight", "topmargin", "bottommargin", "leftmargin", "rightmargin"}));
    }

    public void testAttributesOnHTML5BodyTranslate() {
        this.checkAttrValues("HTML5", "BODY", "translate", new String[]{"", "yes", "no"});
    }

    public void testHTML5document() {
        this.checkDocument("HTML5");
    }

    private void verifyAttributeDeclaration(CMElementDeclaration elemDecl, CMNode attr) {
        HTML5ContentModelTest.assertTrue((attr.getNodeType() == 2 ? 1 : 0) != 0);
        HTML5ContentModelTest.assertNotNull((String)"no name on an attribute declaration", (Object)attr.getNodeName());
        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attr;
        HTML5ContentModelTest.assertNotNull((String)("no attribute 'type' on an attribute declaration " + elemDecl.getNodeName() + "/" + attr.getNodeName()), (Object)attrDecl.getAttrType());
    }

    private void verifyElementDeclarationHasName(CMNode item) {
        HTML5ContentModelTest.assertTrue((item.getNodeType() == 5 ? 1 : 0) != 0);
        HTML5ContentModelTest.assertNotNull((String)"no name on an element declaration", (Object)item.getNodeName());
        CMNamedNodeMap attrs = ((CMElementDeclaration)item).getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            CMNode attr = attrs.item(i);
            this.verifyAttributeDeclaration((CMElementDeclaration)item, attr);
            ++i;
        }
    }
}

