/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.contenttype;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.contenttype.HTMLResourceEncodingDetector;

public class TestHTMLResourceEncodingDetector
extends TestCase {
    HTMLResourceEncodingDetector htmlResouceEncodingDetector;
    private static final String XMLDeclContent_UTF8 = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    private static final String XMLDeclContent_ISO = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>";
    private static final String XHTMLContent_HTML_AS_ROOTELEMENT = "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final String XHTMLContent_NOXHTMLNS = "<?xml version=\"1.0\" encoding=\"UTF-16\" ?><lorem ipsum=\"hami\">";
    private static final String XHTMLContent_NOT_HTML_AS_ROOTELEMENT = "<ui:composition attribut=43 xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final String METAContent = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />";

    public TestHTMLResourceEncodingDetector() {
        this("HTML Resource Encoding Detector");
    }

    public TestHTMLResourceEncodingDetector(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.htmlResouceEncodingDetector = new HTMLResourceEncodingDetector();
    }

    private String getContentType(String content) throws IOException {
        CharArrayReader contentReader = new CharArrayReader(content.toCharArray());
        this.htmlResouceEncodingDetector.set((Reader)contentReader);
        return this.htmlResouceEncodingDetector.getEncoding();
    }

    public void testXMLDecl() throws IOException {
        String contentType = this.getContentType("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><html xmlns=\"http://www.w3.org/1999/xhtml\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />");
        TestHTMLResourceEncodingDetector.assertEquals((String)"UTF-8", (String)contentType);
        contentType = this.getContentType("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?><html xmlns=\"http://www.w3.org/1999/xhtml\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />");
        TestHTMLResourceEncodingDetector.assertEquals((String)"ISO-8859-1", (String)contentType);
        contentType = this.getContentType("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ui:composition attribut=43 xmlns=\"http://www.w3.org/1999/xhtml\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />");
        TestHTMLResourceEncodingDetector.assertEquals((String)"UTF-8", (String)contentType);
        contentType = this.getContentType("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?><ui:composition attribut=43 xmlns=\"http://www.w3.org/1999/xhtml\">");
        TestHTMLResourceEncodingDetector.assertEquals((String)"ISO-8859-1", (String)contentType);
    }

    public void testMetaDecl() throws IOException {
        String contentType = this.getContentType("<html xmlns=\"http://www.w3.org/1999/xhtml\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />");
        TestHTMLResourceEncodingDetector.assertEquals((String)"ISO-8859-1", (String)contentType);
        contentType = this.getContentType("<ui:composition attribut=43 xmlns=\"http://www.w3.org/1999/xhtml\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />");
        TestHTMLResourceEncodingDetector.assertEquals((String)"ISO-8859-1", (String)contentType);
    }

    public void testXHTML() throws IOException {
        String contentType = this.getContentType(XHTMLContent_HTML_AS_ROOTELEMENT);
        TestHTMLResourceEncodingDetector.assertEquals((String)"UTF-8", (String)contentType);
        contentType = this.getContentType(XHTMLContent_NOT_HTML_AS_ROOTELEMENT);
        TestHTMLResourceEncodingDetector.assertEquals((String)"UTF-8", (String)contentType);
        contentType = this.getContentType(XHTMLContent_NOXHTMLNS);
        TestHTMLResourceEncodingDetector.assertEquals((String)"The XML declaration encoding value was ignored", (String)"UTF-16", (String)contentType);
    }
}

