/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.wst.json.core.contenttype.ContentTypeIdForJSON;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONStructure;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TestUtil {
    public static String toString(IJSONDocument document) {
        StringBuilder json = new StringBuilder();
        TestUtil.serialize((IJSONNode)document, json);
        return json.toString();
    }

    private static void serialize(IJSONNode node, StringBuilder json) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case -1: {
                TestUtil.serialize(node.getFirstChild(), json);
                break;
            }
            case 0: 
            case 1: {
                IJSONStructure object = (IJSONStructure)node;
                json.append(object.getFirstStructuredDocumentRegion().getText());
                TestUtil.serialize(node.getFirstChild(), json);
                if (object.isClosed()) {
                    json.append(object.getEndStructuredDocumentRegion().getText());
                }
                if (node.getNextSibling() == null) break;
                json.append(",");
                TestUtil.serialize(node.getNextSibling(), json);
                break;
            }
            case 2: {
                IJSONPair pair = (IJSONPair)node;
                json.append("\"");
                json.append(pair.getName());
                json.append("\"");
                if (pair.getValue() != null) {
                    json.append(":");
                    TestUtil.serialize((IJSONNode)pair.getValue(), json);
                }
                if (node.getNextSibling() == null) break;
                json.append(",");
                TestUtil.serialize(node.getNextSibling(), json);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                IJSONValue value = (IJSONValue)node;
                json.append(value.getSimpleValue());
                if (node.getNextSibling() == null) break;
                json.append(",");
                TestUtil.serialize(node.getNextSibling(), json);
            }
        }
    }

    public static String toString(InputStream is) {
        StringBuilder sb;
        block15: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static IJSONModel loadModel(String json) {
        IJSONModel model = (IJSONModel)TestUtil.createModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(json);
        return model;
    }

    public static IStructuredModel createModel() {
        IModelManager manager = StructuredModelManager.getModelManager();
        return manager.createUnManagedStructuredModelFor(ContentTypeIdForJSON.ContentTypeID_JSON);
    }
}

