/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.BufferCache;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.ElementCache;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.OverflowingLRUCache;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;

public class OverflowingCacheTests
extends ModifyingResourceTests {
    public static Test suite() {
        return OverflowingCacheTests.buildModelTestSuite(OverflowingCacheTests.class);
    }

    public OverflowingCacheTests(String name) {
        super(name);
    }

    private boolean hasUnsavedChanges(int i) {
        return i % 10 != 0;
    }

    public void testBigNumberOfRoots() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            int rootSize = 100;
            int i = 0;
            while (i < rootSize) {
                if (i < 10) {
                    this.createFolder("/P/src00" + i);
                } else if (i < 100) {
                    this.createFolder("/P/src0" + i);
                } else {
                    this.createFolder("/P/src" + i);
                }
                ++i;
            }
            IIncludePathEntry[] classpath = new IIncludePathEntry[rootSize + 1];
            int i2 = 0;
            while (i2 < rootSize) {
                classpath[i2] = i2 < 10 ? JavaScriptCore.newSourceEntry((IPath)new Path("/P/src00" + i2)) : (i2 < 100 ? JavaScriptCore.newSourceEntry((IPath)new Path("/P/src0" + i2)) : JavaScriptCore.newSourceEntry((IPath)new Path("/P/src" + i2)));
                ++i2;
            }
            classpath[rootSize] = JavaScriptCore.newVariableEntry((IPath)new Path("JCL_LIB"), null, null);
            project.setRawIncludepath(classpath, null);
            IJavaScriptElement[] roots = project.getChildren();
            int i3 = 0;
            while (i3 < rootSize) {
                ((IOpenable)roots[i3]).open(null);
                ++i3;
            }
            i3 = 0;
            while (i3 < rootSize) {
                OverflowingCacheTests.assertTrue((String)("Root should be opened " + roots[i3]), (boolean)((IOpenable)roots[i3]).isOpen());
                ++i3;
            }
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testBufferCacheCreation() {
        int spaceLimit = 10;
        int overflow = 0;
        int current = 0;
        BufferCache cache = new BufferCache(spaceLimit);
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTests.assertEquals((String)"space limit incorrect ", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect ", (int)current, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect ", (int)overflow, (int)actualOverflow);
    }

    public void testBufferCacheFill() {
        int spaceLimit = 20;
        int overflow = 0;
        int current = 0;
        BufferCache cache = new BufferCache(spaceLimit);
        OverflowingTestBuffer[] buffers = new OverflowingTestBuffer[spaceLimit];
        OverflowingTestOpenable[] openables = new OverflowingTestOpenable[spaceLimit];
        int i = 0;
        while (i < spaceLimit) {
            buffers[i] = new OverflowingTestBuffer(false, (OverflowingLRUCache)cache);
            openables[i] = new OverflowingTestOpenable(buffers[i], null);
            cache.put((Object)openables[i], (Object)buffers[i]);
            ++current;
            ++i;
        }
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTests.assertEquals((String)"space limit incorrect ", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect ", (int)current, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect ", (int)overflow, (int)actualOverflow);
        i = spaceLimit - 1;
        while (i >= 0) {
            Object value = cache.get((Object)openables[i]);
            OverflowingCacheTests.assertEquals((String)("wrong value (" + i + ")"), (Object)buffers[i], (Object)value);
            --i;
        }
    }

    public void testBufferCacheUseNoOverflow() {
        Object value;
        int spaceLimit = 500;
        int overflow = 0;
        int predictedCurrent = 334;
        int entryCount = 1000;
        BufferCache cache = new BufferCache(spaceLimit);
        OverflowingTestOpenable[] openables = new OverflowingTestOpenable[entryCount];
        OverflowingTestBuffer[] buffers = new OverflowingTestBuffer[entryCount];
        int i = 0;
        while (i < entryCount) {
            buffers[i] = new OverflowingTestBuffer(false, (OverflowingLRUCache)cache);
            openables[i] = new OverflowingTestOpenable(buffers[i], null);
            cache.put((Object)openables[i], (Object)buffers[i]);
            ++i;
        }
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTests.assertEquals((String)"space limit incorrect ", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect ", (int)predictedCurrent, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect ", (int)overflow, (int)actualOverflow);
        i = entryCount - 1;
        while (i >= entryCount - predictedCurrent) {
            value = cache.get((Object)openables[i]);
            OverflowingCacheTests.assertEquals((String)("wrong value (" + i + ")"), (Object)buffers[i], (Object)value);
            --i;
        }
        i = 0;
        while (i < spaceLimit) {
            value = cache.get((Object)openables[i]);
            OverflowingCacheTests.assertEquals((String)"entry should not be present", null, (Object)value);
            ++i;
        }
    }

    public void testBufferCacheUseOverflow() {
        int spaceLimit = 500;
        int entryCount = 1000;
        BufferCache cache = new BufferCache(spaceLimit);
        OverflowingTestOpenable[] openables = new OverflowingTestOpenable[entryCount];
        OverflowingTestBuffer[] buffers = new OverflowingTestBuffer[entryCount];
        int i = 0;
        while (i < entryCount) {
            boolean hasUnsavedChanges = this.hasUnsavedChanges(i);
            buffers[i] = new OverflowingTestBuffer(hasUnsavedChanges, (OverflowingLRUCache)cache);
            openables[i] = new OverflowingTestOpenable(buffers[i], null);
            cache.put((Object)openables[i], (Object)buffers[i]);
            ++i;
        }
        Hashtable table = cache.getEntryTable();
        OverflowingCacheTests.assertEquals((String)"Hashtable wrong size", (int)900, (int)table.size());
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect", (int)900, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect", (int)400, (int)actualOverflow);
        int i2 = entryCount - 1;
        while (i2 >= 0) {
            if (this.hasUnsavedChanges(i2)) {
                Object value = cache.get((Object)openables[i2]);
                OverflowingCacheTests.assertEquals((String)("wrong value (" + i2 + ")"), (Object)buffers[i2], (Object)value);
            }
            --i2;
        }
        i2 = 0;
        while (i2 < entryCount) {
            buffers[i2].save(null, false);
            ++i2;
        }
        OverflowingTestBuffer buffer1 = new OverflowingTestBuffer(false, (OverflowingLRUCache)cache);
        OverflowingTestOpenable openable1 = new OverflowingTestOpenable(buffer1, null);
        cache.put((Object)openable1, (Object)buffer1);
        actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect (after flush)", (int)168, (int)actualCurrent);
        actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect (after flush)", (int)0, (int)actualOverflow);
    }

    public void testBufferRecycling() throws CoreException {
        Enumeration openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
        while (openBuffers.hasMoreElements()) {
            IBuffer buf = (IBuffer)openBuffers.nextElement();
            buf.close();
        }
        openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
        OverflowingCacheTests.assertTrue((String)"buffer cache not empty", (!openBuffers.hasMoreElements() ? 1 : 0) != 0);
        try {
            this.createJavaProject("P");
            int i = 0;
            while (i < 61) {
                this.createFile("P/X" + i + ".js", "public class X" + i + " {\n" + "}");
                ++i;
            }
            IPackageFragment pkg = this.getPackage("P");
            IJavaScriptUnit[] cus = pkg.getJavaScriptUnits();
            int max = 60;
            int i2 = 0;
            while (i2 < max) {
                cus[i2].getBuffer();
                ++i2;
            }
            openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
            int count = 0;
            while (openBuffers.hasMoreElements()) {
                openBuffers.nextElement();
                ++count;
            }
            OverflowingCacheTests.assertEquals((String)"incorrect numbers of open buffers (1)", (int)max, (int)count);
            cus[max].getBuffer();
            openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
            count = 0;
            while (openBuffers.hasMoreElements()) {
                openBuffers.nextElement();
                ++count;
            }
            OverflowingCacheTests.assertEquals((String)"incorrect numbers of open buffers (2)", (int)21, (int)count);
            cus[0].getBuffer();
            openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
            count = 0;
            while (openBuffers.hasMoreElements()) {
                openBuffers.nextElement();
                ++count;
            }
            OverflowingCacheTests.assertEquals((String)"incorrect numbers of open buffers (3)", (int)22, (int)count);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testElementCacheCreation() {
        int spaceLimit = 10;
        int overflow = 0;
        int current = 0;
        ElementCache cache = new ElementCache(spaceLimit);
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTests.assertEquals((String)"space limit incorrect ", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect ", (int)current, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect ", (int)overflow, (int)actualOverflow);
    }

    public void testElementCacheFill() {
        int spaceLimit = 500;
        int overflow = 0;
        int current = 0;
        ElementCache cache = new ElementCache(spaceLimit);
        OverflowingTestOpenable[] openables = new OverflowingTestOpenable[spaceLimit];
        int i = 0;
        while (i < spaceLimit) {
            openables[i] = new OverflowingTestOpenable(new OverflowingTestBuffer(false, null), (OverflowingLRUCache)cache);
            cache.put((Object)openables[i], (Object)Integer.toString(i));
            ++current;
            ++i;
        }
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTests.assertEquals((String)"space limit incorrect ", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect ", (int)current, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect ", (int)overflow, (int)actualOverflow);
        i = spaceLimit - 1;
        while (i >= 0) {
            Object value = cache.get((Object)openables[i]);
            OverflowingCacheTests.assertEquals((String)("wrong value (" + i + ")"), (Object)Integer.toString(i), (Object)value);
            --i;
        }
    }

    public void testElementCacheUseNoOverflow() {
        Object value;
        int spaceLimit = 500;
        int overflow = 0;
        int predictedCurrent = 334;
        int entryCount = 1000;
        ElementCache cache = new ElementCache(spaceLimit);
        OverflowingTestOpenable[] openables = new OverflowingTestOpenable[entryCount];
        int i = 0;
        while (i < entryCount) {
            openables[i] = new OverflowingTestOpenable(new OverflowingTestBuffer(false, null), (OverflowingLRUCache)cache);
            cache.put((Object)openables[i], (Object)Integer.toString(i));
            ++i;
        }
        int actualSpaceLimit = cache.getSpaceLimit();
        OverflowingCacheTests.assertEquals((String)"space limit incorrect ", (int)spaceLimit, (int)actualSpaceLimit);
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect ", (int)predictedCurrent, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect ", (int)overflow, (int)actualOverflow);
        i = entryCount - 1;
        while (i >= entryCount - predictedCurrent) {
            value = cache.get((Object)openables[i]);
            OverflowingCacheTests.assertEquals((String)("wrong value (" + i + ")"), (Object)Integer.toString(i), (Object)value);
            --i;
        }
        i = 0;
        while (i < spaceLimit) {
            value = cache.get((Object)openables[i]);
            OverflowingCacheTests.assertEquals((String)"entry should not be present", null, (Object)value);
            ++i;
        }
    }

    public void testElementCacheUseOverflow() {
        int spaceLimit = 500;
        int entryCount = 1000;
        ElementCache cache = new ElementCache(spaceLimit);
        OverflowingTestOpenable[] openables = new OverflowingTestOpenable[entryCount];
        int i = 0;
        while (i < entryCount) {
            openables[i] = new OverflowingTestOpenable(new OverflowingTestBuffer(this.hasUnsavedChanges(i), null), (OverflowingLRUCache)cache);
            cache.put((Object)openables[i], (Object)Integer.toString(i));
            ++i;
        }
        Hashtable table = cache.getEntryTable();
        OverflowingCacheTests.assertEquals((String)"Hashtable wrong size", (int)900, (int)table.size());
        int actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect", (int)900, (int)actualCurrent);
        int actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect", (int)400, (int)actualOverflow);
        int i2 = entryCount - 1;
        while (i2 >= 0) {
            if (this.hasUnsavedChanges(i2)) {
                Object value = cache.get((Object)openables[i2]);
                OverflowingCacheTests.assertEquals((String)("wrong value (" + i2 + ")"), (Object)Integer.toString(i2), (Object)value);
            }
            --i2;
        }
        i2 = 0;
        while (i2 < entryCount) {
            openables[i2].save(null, false);
            ++i2;
        }
        cache.put((Object)Integer.toString(1001), (Object)new OverflowingTestOpenable(new OverflowingTestBuffer(false, null), (OverflowingLRUCache)cache));
        actualCurrent = cache.getCurrentSpace();
        OverflowingCacheTests.assertEquals((String)"current space incorrect (after flush)", (int)168, (int)actualCurrent);
        actualOverflow = cache.getOverflow();
        OverflowingCacheTests.assertEquals((String)"overflow space incorrect (after flush)", (int)0, (int)actualOverflow);
    }

    public class OverflowingTestBuffer
    implements IBuffer {
        public boolean isOpen;
        public boolean hasUnsavedChanges;
        public OverflowingLRUCache cache;
        public IOpenable owner;

        public OverflowingTestBuffer(boolean hasUnsavedChanges, OverflowingLRUCache cache) {
            this.hasUnsavedChanges = hasUnsavedChanges;
            this.cache = cache;
        }

        public void addBufferChangedListener(IBufferChangedListener listener) {
        }

        public void append(char[] text) {
            this.hasUnsavedChanges = true;
        }

        public void append(String text) {
            this.hasUnsavedChanges = true;
        }

        public void close() {
            this.isOpen = false;
            this.cache.remove((Object)this.owner);
        }

        public char getChar(int position) {
            return '.';
        }

        public char[] getCharacters() {
            return null;
        }

        public String getContents() {
            return null;
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return this.owner;
        }

        public String getText(int beginIndex, int endIndex) {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return this.hasUnsavedChanges;
        }

        public boolean isClosed() {
            return !this.isOpen;
        }

        public boolean isReadOnly() {
            return false;
        }

        public void removeBufferChangedListener(IBufferChangedListener listener) {
        }

        public void replace(int position, int length, char[] text) {
            this.hasUnsavedChanges = true;
        }

        public void replace(int position, int length, String text) {
            this.hasUnsavedChanges = true;
        }

        public void save(IProgressMonitor progress) throws IllegalArgumentException {
            this.save(progress, false);
        }

        public void save(IProgressMonitor progress, boolean force) throws IllegalArgumentException {
            this.hasUnsavedChanges = false;
        }

        public void setContents(char[] contents) {
            this.hasUnsavedChanges = true;
        }

        public void setContents(String contents) {
            this.hasUnsavedChanges = true;
        }
    }

    public class OverflowingTestOpenable
    extends Openable {
        public boolean isOpen;
        public OverflowingTestBuffer buffer;
        public OverflowingLRUCache cache;

        public OverflowingTestOpenable(OverflowingTestBuffer buffer, OverflowingLRUCache cache) {
            super(null);
            this.buffer = buffer;
            buffer.owner = this;
            this.cache = cache;
            this.open(null);
        }

        protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) {
            return false;
        }

        public void close() {
            this.isOpen = false;
            this.cache.remove((Object)this);
        }

        public boolean equals(Object o) {
            if (!(o instanceof OverflowingTestOpenable)) {
                return false;
            }
            return super.equals(o);
        }

        public IBuffer getBuffer() {
            return null;
        }

        public int getElementType() {
            return 0;
        }

        public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
            return null;
        }

        protected char getHandleMementoDelimiter() {
            return '\u0000';
        }

        public IPath getPath() {
            return null;
        }

        public IResource getResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return this.buffer.hasUnsavedChanges();
        }

        public boolean isConsistent() {
            return true;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public void makeConsistent(IProgressMonitor pm) {
        }

        public void open(IProgressMonitor pm) {
            this.isOpen = true;
        }

        public void save(IProgressMonitor pm) {
            this.save(pm, false);
        }

        public void save(IProgressMonitor pm, boolean force) {
            this.buffer.hasUnsavedChanges = false;
        }
    }
}

